<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SalutationTarget EnumType
 * @subpackage Enumerations
 */
class SalutationTarget extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Male'
     * @return string 'Male'
     */
    const VALUE_MALE = 'Male';
    /**
     * Constant for value 'Female'
     * @return string 'Female'
     */
    const VALUE_FEMALE = 'Female';
    /**
     * Constant for value 'Company'
     * @return string 'Company'
     */
    const VALUE_COMPANY = 'Company';
    /**
     * Constant for value 'Family'
     * @return string 'Family'
     */
    const VALUE_FAMILY = 'Family';
    /**
     * Constant for value 'Divers'
     * @return string 'Divers'
     */
    const VALUE_DIVERS = 'Divers';
    /**
     * Constant for value 'Authorities'
     * @return string 'Authorities'
     */
    const VALUE_AUTHORITIES = 'Authorities';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_MALE
     * @uses self::VALUE_FEMALE
     * @uses self::VALUE_COMPANY
     * @uses self::VALUE_FAMILY
     * @uses self::VALUE_DIVERS
     * @uses self::VALUE_AUTHORITIES
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_MALE,
            self::VALUE_FEMALE,
            self::VALUE_COMPANY,
            self::VALUE_FAMILY,
            self::VALUE_DIVERS,
            self::VALUE_AUTHORITIES,
            self::VALUE_OTHER,
        );
    }
}
