<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RoundingMode EnumType
 * @subpackage Enumerations
 */
class RoundingMode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Constant for value 'DOWN'
     * @return string 'DOWN'
     */
    const VALUE_DOWN = 'DOWN';
    /**
     * Constant for value 'HALF_DOWN'
     * @return string 'HALF_DOWN'
     */
    const VALUE_HALF_DOWN = 'HALF_DOWN';
    /**
     * Constant for value 'UP'
     * @return string 'UP'
     */
    const VALUE_UP = 'UP';
    /**
     * Constant for value 'HALF_UP'
     * @return string 'HALF_UP'
     */
    const VALUE_HALF_UP = 'HALF_UP';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_DOWN
     * @uses self::VALUE_HALF_DOWN
     * @uses self::VALUE_UP
     * @uses self::VALUE_HALF_UP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_DOWN,
            self::VALUE_HALF_DOWN,
            self::VALUE_UP,
            self::VALUE_HALF_UP,
        );
    }
}
