<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EntityType EnumType
 * @subpackage Enumerations
 */
class EntityType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Natural'
     * @return string 'Natural'
     */
    const VALUE_NATURAL = 'Natural';
    /**
     * Constant for value 'Legal'
     * @return string 'Legal'
     */
    const VALUE_LEGAL = 'Legal';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_NATURAL
     * @uses self::VALUE_LEGAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_NATURAL,
            self::VALUE_LEGAL,
        );
    }
}
