<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DeliveryStatus EnumType
 * @subpackage Enumerations
 */
class DeliveryStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Constant for value 'Delivered'
     * @return string 'Delivered'
     */
    const VALUE_DELIVERED = 'Delivered';
    /**
     * Constant for value 'PartlyDelivered'
     * @return string 'PartlyDelivered'
     */
    const VALUE_PARTLY_DELIVERED = 'PartlyDelivered';
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_PARTLY_DELIVERED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_OPEN,
            self::VALUE_DELIVERED,
            self::VALUE_PARTLY_DELIVERED,
        );
    }
}
