<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AddressCategory EnumType
 * @subpackage Enumerations
 */
class AddressCategory extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Residence'
     * @return string 'Residence'
     */
    const VALUE_RESIDENCE = 'Residence';
    /**
     * Constant for value 'PoBox'
     * @return string 'PoBox'
     */
    const VALUE_PO_BOX = 'PoBox';
    /**
     * Constant for value 'PickUpStation'
     * @return string 'PickUpStation'
     */
    const VALUE_PICK_UP_STATION = 'PickUpStation';
    /**
     * Constant for value 'PostOffice'
     * @return string 'PostOffice'
     */
    const VALUE_POST_OFFICE = 'PostOffice';
    /**
     * Return allowed values
     * @uses self::VALUE_RESIDENCE
     * @uses self::VALUE_PO_BOX
     * @uses self::VALUE_PICK_UP_STATION
     * @uses self::VALUE_POST_OFFICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RESIDENCE,
            self::VALUE_PO_BOX,
            self::VALUE_PICK_UP_STATION,
            self::VALUE_POST_OFFICE,
        );
    }
}
