<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceReference ArrayType
 * @subpackage Arrays
 */
class ArrayOfServiceReference extends AbstractStructArrayBase
{
    /**
     * The ServiceReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceReference[]
     */
    public $ServiceReference;
    /**
     * Constructor method for ArrayOfServiceReference
     * @uses ArrayOfServiceReference::setServiceReference()
     * @param \StructType\ServiceReference[] $serviceReference
     */
    public function __construct(array $serviceReference = array())
    {
        $this
            ->setServiceReference($serviceReference);
    }
    /**
     * Get ServiceReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceReference[]|null
     */
    public function getServiceReference()
    {
        return isset($this->ServiceReference) ? $this->ServiceReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceReferenceForArrayConstraintsFromSetServiceReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceReferenceServiceReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceReferenceServiceReferenceItem instanceof \StructType\ServiceReference) {
                $invalidValues[] = is_object($arrayOfServiceReferenceServiceReferenceItem) ? get_class($arrayOfServiceReferenceServiceReferenceItem) : sprintf('%s(%s)', gettype($arrayOfServiceReferenceServiceReferenceItem), var_export($arrayOfServiceReferenceServiceReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceReference property can only contain items of type \StructType\ServiceReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceReference[] $serviceReference
     * @return \ArrayType\ArrayOfServiceReference
     */
    public function setServiceReference(array $serviceReference = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceReferenceArrayErrorMessage = self::validateServiceReferenceForArrayConstraintsFromSetServiceReference($serviceReference))) {
            throw new \InvalidArgumentException($serviceReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceReference) || (is_array($serviceReference) && empty($serviceReference))) {
            unset($this->ServiceReference);
        } else {
            $this->ServiceReference = $serviceReference;
        }
        return $this;
    }
    /**
     * Add item to ServiceReference value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceReference $item
     * @return \ArrayType\ArrayOfServiceReference
     */
    public function addToServiceReference(\StructType\ServiceReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceReference) {
            throw new \InvalidArgumentException(sprintf('The ServiceReference property can only contain items of type \StructType\ServiceReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceReference
     */
    public function getAttributeName()
    {
        return 'ServiceReference';
    }
}
