<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductGroup extends AbstractStructArrayBase
{
    /**
     * The ProductGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductGroup[]
     */
    public $ProductGroup;
    /**
     * Constructor method for ArrayOfProductGroup
     * @uses ArrayOfProductGroup::setProductGroup()
     * @param \StructType\ProductGroup[] $productGroup
     */
    public function __construct(array $productGroup = array())
    {
        $this
            ->setProductGroup($productGroup);
    }
    /**
     * Get ProductGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductGroup[]|null
     */
    public function getProductGroup()
    {
        return isset($this->ProductGroup) ? $this->ProductGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductGroupForArrayConstraintsFromSetProductGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductGroupProductGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductGroupProductGroupItem instanceof \StructType\ProductGroup) {
                $invalidValues[] = is_object($arrayOfProductGroupProductGroupItem) ? get_class($arrayOfProductGroupProductGroupItem) : sprintf('%s(%s)', gettype($arrayOfProductGroupProductGroupItem), var_export($arrayOfProductGroupProductGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductGroup property can only contain items of type \StructType\ProductGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductGroup[] $productGroup
     * @return \ArrayType\ArrayOfProductGroup
     */
    public function setProductGroup(array $productGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($productGroupArrayErrorMessage = self::validateProductGroupForArrayConstraintsFromSetProductGroup($productGroup))) {
            throw new \InvalidArgumentException($productGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($productGroup) || (is_array($productGroup) && empty($productGroup))) {
            unset($this->ProductGroup);
        } else {
            $this->ProductGroup = $productGroup;
        }
        return $this;
    }
    /**
     * Add item to ProductGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductGroup $item
     * @return \ArrayType\ArrayOfProductGroup
     */
    public function addToProductGroup(\StructType\ProductGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductGroup) {
            throw new \InvalidArgumentException(sprintf('The ProductGroup property can only contain items of type \StructType\ProductGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductGroup
     */
    public function getAttributeName()
    {
        return 'ProductGroup';
    }
}
