<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderPosition ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderPosition extends AbstractStructArrayBase
{
    /**
     * The OrderPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderPosition[]
     */
    public $OrderPosition;
    /**
     * Constructor method for ArrayOfOrderPosition
     * @uses ArrayOfOrderPosition::setOrderPosition()
     * @param \StructType\OrderPosition[] $orderPosition
     */
    public function __construct(array $orderPosition = array())
    {
        $this
            ->setOrderPosition($orderPosition);
    }
    /**
     * Get OrderPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderPosition[]|null
     */
    public function getOrderPosition()
    {
        return isset($this->OrderPosition) ? $this->OrderPosition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderPositionForArrayConstraintsFromSetOrderPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderPositionOrderPositionItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderPositionOrderPositionItem instanceof \StructType\OrderPosition) {
                $invalidValues[] = is_object($arrayOfOrderPositionOrderPositionItem) ? get_class($arrayOfOrderPositionOrderPositionItem) : sprintf('%s(%s)', gettype($arrayOfOrderPositionOrderPositionItem), var_export($arrayOfOrderPositionOrderPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderPosition property can only contain items of type \StructType\OrderPosition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderPosition[] $orderPosition
     * @return \ArrayType\ArrayOfOrderPosition
     */
    public function setOrderPosition(array $orderPosition = array())
    {
        // validation for constraint: array
        if ('' !== ($orderPositionArrayErrorMessage = self::validateOrderPositionForArrayConstraintsFromSetOrderPosition($orderPosition))) {
            throw new \InvalidArgumentException($orderPositionArrayErrorMessage, __LINE__);
        }
        if (is_null($orderPosition) || (is_array($orderPosition) && empty($orderPosition))) {
            unset($this->OrderPosition);
        } else {
            $this->OrderPosition = $orderPosition;
        }
        return $this;
    }
    /**
     * Add item to OrderPosition value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderPosition $item
     * @return \ArrayType\ArrayOfOrderPosition
     */
    public function addToOrderPosition(\StructType\OrderPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderPosition) {
            throw new \InvalidArgumentException(sprintf('The OrderPosition property can only contain items of type \StructType\OrderPosition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderPosition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderPosition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderPosition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderPosition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderPosition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderPosition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderPosition
     */
    public function getAttributeName()
    {
        return 'OrderPosition';
    }
}
