<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLanguage ArrayType
 * @subpackage Arrays
 */
class ArrayOfLanguage extends AbstractStructArrayBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Language[]
     */
    public $Language;
    /**
     * Constructor method for ArrayOfLanguage
     * @uses ArrayOfLanguage::setLanguage()
     * @param \StructType\Language[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Language[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLanguageLanguageItem) {
            // validation for constraint: itemType
            if (!$arrayOfLanguageLanguageItem instanceof \StructType\Language) {
                $invalidValues[] = is_object($arrayOfLanguageLanguageItem) ? get_class($arrayOfLanguageLanguageItem) : sprintf('%s(%s)', gettype($arrayOfLanguageLanguageItem), var_export($arrayOfLanguageLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language property can only contain items of type \StructType\Language, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Language[] $language
     * @return \ArrayType\ArrayOfLanguage
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Add item to Language value
     * @throws \InvalidArgumentException
     * @param \StructType\Language $item
     * @return \ArrayType\ArrayOfLanguage
     */
    public function addToLanguage(\StructType\Language $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Language) {
            throw new \InvalidArgumentException(sprintf('The Language property can only contain items of type \StructType\Language, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Language|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Language|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Language|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Language|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Language|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Language
     */
    public function getAttributeName()
    {
        return 'Language';
    }
}
