<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmployee ArrayType
 * @subpackage Arrays
 */
class ArrayOfEmployee extends AbstractStructArrayBase
{
    /**
     * The Employee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Employee[]
     */
    public $Employee;
    /**
     * Constructor method for ArrayOfEmployee
     * @uses ArrayOfEmployee::setEmployee()
     * @param \StructType\Employee[] $employee
     */
    public function __construct(array $employee = array())
    {
        $this
            ->setEmployee($employee);
    }
    /**
     * Get Employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Employee[]|null
     */
    public function getEmployee()
    {
        return isset($this->Employee) ? $this->Employee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeForArrayConstraintsFromSetEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEmployeeEmployeeItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmployeeEmployeeItem instanceof \StructType\Employee) {
                $invalidValues[] = is_object($arrayOfEmployeeEmployeeItem) ? get_class($arrayOfEmployeeEmployeeItem) : sprintf('%s(%s)', gettype($arrayOfEmployeeEmployeeItem), var_export($arrayOfEmployeeEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employee property can only contain items of type \StructType\Employee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Employee[] $employee
     * @return \ArrayType\ArrayOfEmployee
     */
    public function setEmployee(array $employee = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeArrayErrorMessage = self::validateEmployeeForArrayConstraintsFromSetEmployee($employee))) {
            throw new \InvalidArgumentException($employeeArrayErrorMessage, __LINE__);
        }
        if (is_null($employee) || (is_array($employee) && empty($employee))) {
            unset($this->Employee);
        } else {
            $this->Employee = $employee;
        }
        return $this;
    }
    /**
     * Add item to Employee value
     * @throws \InvalidArgumentException
     * @param \StructType\Employee $item
     * @return \ArrayType\ArrayOfEmployee
     */
    public function addToEmployee(\StructType\Employee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Employee) {
            throw new \InvalidArgumentException(sprintf('The Employee property can only contain items of type \StructType\Employee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employee[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Employee|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Employee|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Employee|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Employee|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Employee|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Employee
     */
    public function getAttributeName()
    {
        return 'Employee';
    }
}
