<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeliveryNote ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeliveryNote extends AbstractStructArrayBase
{
    /**
     * The DeliveryNote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveryNote[]
     */
    public $DeliveryNote;
    /**
     * Constructor method for ArrayOfDeliveryNote
     * @uses ArrayOfDeliveryNote::setDeliveryNote()
     * @param \StructType\DeliveryNote[] $deliveryNote
     */
    public function __construct(array $deliveryNote = array())
    {
        $this
            ->setDeliveryNote($deliveryNote);
    }
    /**
     * Get DeliveryNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveryNote[]|null
     */
    public function getDeliveryNote()
    {
        return isset($this->DeliveryNote) ? $this->DeliveryNote : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryNoteForArrayConstraintsFromSetDeliveryNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeliveryNoteDeliveryNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeliveryNoteDeliveryNoteItem instanceof \StructType\DeliveryNote) {
                $invalidValues[] = is_object($arrayOfDeliveryNoteDeliveryNoteItem) ? get_class($arrayOfDeliveryNoteDeliveryNoteItem) : sprintf('%s(%s)', gettype($arrayOfDeliveryNoteDeliveryNoteItem), var_export($arrayOfDeliveryNoteDeliveryNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryNote property can only contain items of type \StructType\DeliveryNote, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveryNote[] $deliveryNote
     * @return \ArrayType\ArrayOfDeliveryNote
     */
    public function setDeliveryNote(array $deliveryNote = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryNoteArrayErrorMessage = self::validateDeliveryNoteForArrayConstraintsFromSetDeliveryNote($deliveryNote))) {
            throw new \InvalidArgumentException($deliveryNoteArrayErrorMessage, __LINE__);
        }
        if (is_null($deliveryNote) || (is_array($deliveryNote) && empty($deliveryNote))) {
            unset($this->DeliveryNote);
        } else {
            $this->DeliveryNote = $deliveryNote;
        }
        return $this;
    }
    /**
     * Add item to DeliveryNote value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveryNote $item
     * @return \ArrayType\ArrayOfDeliveryNote
     */
    public function addToDeliveryNote(\StructType\DeliveryNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveryNote) {
            throw new \InvalidArgumentException(sprintf('The DeliveryNote property can only contain items of type \StructType\DeliveryNote, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryNote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeliveryNote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeliveryNote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeliveryNote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeliveryNote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeliveryNote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeliveryNote
     */
    public function getAttributeName()
    {
        return 'DeliveryNote';
    }
}
