<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCharacteristic ArrayType
 * @subpackage Arrays
 */
class ArrayOfCharacteristic extends AbstractStructArrayBase
{
    /**
     * The Characteristic
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Characteristic[]
     */
    public $Characteristic;
    /**
     * Constructor method for ArrayOfCharacteristic
     * @uses ArrayOfCharacteristic::setCharacteristic()
     * @param \StructType\Characteristic[] $characteristic
     */
    public function __construct(array $characteristic = array())
    {
        $this
            ->setCharacteristic($characteristic);
    }
    /**
     * Get Characteristic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Characteristic[]|null
     */
    public function getCharacteristic()
    {
        return isset($this->Characteristic) ? $this->Characteristic : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCharacteristic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharacteristic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCharacteristicForArrayConstraintsFromSetCharacteristic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCharacteristicCharacteristicItem) {
            // validation for constraint: itemType
            if (!$arrayOfCharacteristicCharacteristicItem instanceof \StructType\Characteristic) {
                $invalidValues[] = is_object($arrayOfCharacteristicCharacteristicItem) ? get_class($arrayOfCharacteristicCharacteristicItem) : sprintf('%s(%s)', gettype($arrayOfCharacteristicCharacteristicItem), var_export($arrayOfCharacteristicCharacteristicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Characteristic property can only contain items of type \StructType\Characteristic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Characteristic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Characteristic[] $characteristic
     * @return \ArrayType\ArrayOfCharacteristic
     */
    public function setCharacteristic(array $characteristic = array())
    {
        // validation for constraint: array
        if ('' !== ($characteristicArrayErrorMessage = self::validateCharacteristicForArrayConstraintsFromSetCharacteristic($characteristic))) {
            throw new \InvalidArgumentException($characteristicArrayErrorMessage, __LINE__);
        }
        if (is_null($characteristic) || (is_array($characteristic) && empty($characteristic))) {
            unset($this->Characteristic);
        } else {
            $this->Characteristic = $characteristic;
        }
        return $this;
    }
    /**
     * Add item to Characteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\Characteristic $item
     * @return \ArrayType\ArrayOfCharacteristic
     */
    public function addToCharacteristic(\StructType\Characteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Characteristic) {
            throw new \InvalidArgumentException(sprintf('The Characteristic property can only contain items of type \StructType\Characteristic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Characteristic[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Characteristic|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Characteristic|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Characteristic|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Characteristic|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Characteristic|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Characteristic
     */
    public function getAttributeName()
    {
        return 'Characteristic';
    }
}
