<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArticle ArrayType
 * @subpackage Arrays
 */
class ArrayOfArticle extends AbstractStructArrayBase
{
    /**
     * The Article
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Article[]
     */
    public $Article;
    /**
     * Constructor method for ArrayOfArticle
     * @uses ArrayOfArticle::setArticle()
     * @param \StructType\Article[] $article
     */
    public function __construct(array $article = array())
    {
        $this
            ->setArticle($article);
    }
    /**
     * Get Article value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Article[]|null
     */
    public function getArticle()
    {
        return isset($this->Article) ? $this->Article : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArticle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArticle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArticleForArrayConstraintsFromSetArticle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArticleArticleItem) {
            // validation for constraint: itemType
            if (!$arrayOfArticleArticleItem instanceof \StructType\Article) {
                $invalidValues[] = is_object($arrayOfArticleArticleItem) ? get_class($arrayOfArticleArticleItem) : sprintf('%s(%s)', gettype($arrayOfArticleArticleItem), var_export($arrayOfArticleArticleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Article property can only contain items of type \StructType\Article, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Article value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Article[] $article
     * @return \ArrayType\ArrayOfArticle
     */
    public function setArticle(array $article = array())
    {
        // validation for constraint: array
        if ('' !== ($articleArrayErrorMessage = self::validateArticleForArrayConstraintsFromSetArticle($article))) {
            throw new \InvalidArgumentException($articleArrayErrorMessage, __LINE__);
        }
        if (is_null($article) || (is_array($article) && empty($article))) {
            unset($this->Article);
        } else {
            $this->Article = $article;
        }
        return $this;
    }
    /**
     * Add item to Article value
     * @throws \InvalidArgumentException
     * @param \StructType\Article $item
     * @return \ArrayType\ArrayOfArticle
     */
    public function addToArticle(\StructType\Article $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Article) {
            throw new \InvalidArgumentException(sprintf('The Article property can only contain items of type \StructType\Article, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Article[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Article|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Article|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Article|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Article|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Article|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Article
     */
    public function getAttributeName()
    {
        return 'Article';
    }
}
