<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPSetArticleAttributes StructType
 * @subpackage Structs
 */
class OXERPSetArticleAttributes extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sArticleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sArticleID;
    /**
     * The aAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOXERPType
     */
    public $aAttributes;
    /**
     * Constructor method for OXERPSetArticleAttributes
     * @uses OXERPSetArticleAttributes::setSSessionID()
     * @uses OXERPSetArticleAttributes::setSArticleID()
     * @uses OXERPSetArticleAttributes::setAAttributes()
     * @param string $sSessionID
     * @param string $sArticleID
     * @param \ArrayType\ArrayOfOXERPType $aAttributes
     */
    public function __construct($sSessionID = null, $sArticleID = null, \ArrayType\ArrayOfOXERPType $aAttributes = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSArticleID($sArticleID)
            ->setAAttributes($aAttributes);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPSetArticleAttributes
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sArticleID value
     * @return string|null
     */
    public function getSArticleID()
    {
        return $this->sArticleID;
    }
    /**
     * Set sArticleID value
     * @param string $sArticleID
     * @return \StructType\OXERPSetArticleAttributes
     */
    public function setSArticleID($sArticleID = null)
    {
        // validation for constraint: string
        if (!is_null($sArticleID) && !is_string($sArticleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sArticleID, true), gettype($sArticleID)), __LINE__);
        }
        $this->sArticleID = $sArticleID;
        return $this;
    }
    /**
     * Get aAttributes value
     * @return \ArrayType\ArrayOfOXERPType|null
     */
    public function getAAttributes()
    {
        return $this->aAttributes;
    }
    /**
     * Set aAttributes value
     * @param \ArrayType\ArrayOfOXERPType $aAttributes
     * @return \StructType\OXERPSetArticleAttributes
     */
    public function setAAttributes(\ArrayType\ArrayOfOXERPType $aAttributes = null)
    {
        $this->aAttributes = $aAttributes;
        return $this;
    }
}
