<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetUser StructType
 * @subpackage Structs
 */
class OXERPGetUser extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserID;
    /**
     * Constructor method for OXERPGetUser
     * @uses OXERPGetUser::setSSessionID()
     * @uses OXERPGetUser::setSUserID()
     * @param string $sSessionID
     * @param string $sUserID
     */
    public function __construct($sSessionID = null, $sUserID = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSUserID($sUserID);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetUser
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sUserID value
     * @return string|null
     */
    public function getSUserID()
    {
        return $this->sUserID;
    }
    /**
     * Set sUserID value
     * @param string $sUserID
     * @return \StructType\OXERPGetUser
     */
    public function setSUserID($sUserID = null)
    {
        // validation for constraint: string
        if (!is_null($sUserID) && !is_string($sUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserID, true), gettype($sUserID)), __LINE__);
        }
        $this->sUserID = $sUserID;
        return $this;
    }
}
