<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetAttributes StructType
 * @subpackage Structs
 */
class OXERPGetAttributes extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The OXERPSort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXERPSort
     */
    public $OXERPSort;
    /**
     * The iStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iStart;
    /**
     * The iCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iCount;
    /**
     * The sIn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sIn;
    /**
     * Constructor method for OXERPGetAttributes
     * @uses OXERPGetAttributes::setSSessionID()
     * @uses OXERPGetAttributes::setOXERPSort()
     * @uses OXERPGetAttributes::setIStart()
     * @uses OXERPGetAttributes::setICount()
     * @uses OXERPGetAttributes::setSIn()
     * @param string $sSessionID
     * @param \StructType\OXERPSort $oXERPSort
     * @param int $iStart
     * @param int $iCount
     * @param string $sIn
     */
    public function __construct($sSessionID = null, \StructType\OXERPSort $oXERPSort = null, $iStart = null, $iCount = null, $sIn = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setOXERPSort($oXERPSort)
            ->setIStart($iStart)
            ->setICount($iCount)
            ->setSIn($sIn);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetAttributes
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get OXERPSort value
     * @return \StructType\OXERPSort|null
     */
    public function getOXERPSort()
    {
        return $this->OXERPSort;
    }
    /**
     * Set OXERPSort value
     * @param \StructType\OXERPSort $oXERPSort
     * @return \StructType\OXERPGetAttributes
     */
    public function setOXERPSort(\StructType\OXERPSort $oXERPSort = null)
    {
        $this->OXERPSort = $oXERPSort;
        return $this;
    }
    /**
     * Get iStart value
     * @return int|null
     */
    public function getIStart()
    {
        return $this->iStart;
    }
    /**
     * Set iStart value
     * @param int $iStart
     * @return \StructType\OXERPGetAttributes
     */
    public function setIStart($iStart = null)
    {
        // validation for constraint: int
        if (!is_null($iStart) && !(is_int($iStart) || ctype_digit($iStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iStart, true), gettype($iStart)), __LINE__);
        }
        $this->iStart = $iStart;
        return $this;
    }
    /**
     * Get iCount value
     * @return int|null
     */
    public function getICount()
    {
        return $this->iCount;
    }
    /**
     * Set iCount value
     * @param int $iCount
     * @return \StructType\OXERPGetAttributes
     */
    public function setICount($iCount = null)
    {
        // validation for constraint: int
        if (!is_null($iCount) && !(is_int($iCount) || ctype_digit($iCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iCount, true), gettype($iCount)), __LINE__);
        }
        $this->iCount = $iCount;
        return $this;
    }
    /**
     * Get sIn value
     * @return string|null
     */
    public function getSIn()
    {
        return $this->sIn;
    }
    /**
     * Set sIn value
     * @param string $sIn
     * @return \StructType\OXERPGetAttributes
     */
    public function setSIn($sIn = null)
    {
        // validation for constraint: string
        if (!is_null($sIn) && !is_string($sIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIn, true), gettype($sIn)), __LINE__);
        }
        $this->sIn = $sIn;
        return $this;
    }
}
