<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetArticleAttributes StructType
 * @subpackage Structs
 */
class OXERPGetArticleAttributes extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sArticleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sArticleID;
    /**
     * The sAttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAttributeID;
    /**
     * The OXERPSort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXERPSort
     */
    public $OXERPSort;
    /**
     * The iStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iStart;
    /**
     * The iCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iCount;
    /**
     * Constructor method for OXERPGetArticleAttributes
     * @uses OXERPGetArticleAttributes::setSSessionID()
     * @uses OXERPGetArticleAttributes::setSArticleID()
     * @uses OXERPGetArticleAttributes::setSAttributeID()
     * @uses OXERPGetArticleAttributes::setOXERPSort()
     * @uses OXERPGetArticleAttributes::setIStart()
     * @uses OXERPGetArticleAttributes::setICount()
     * @param string $sSessionID
     * @param string $sArticleID
     * @param string $sAttributeID
     * @param \StructType\OXERPSort $oXERPSort
     * @param int $iStart
     * @param int $iCount
     */
    public function __construct($sSessionID = null, $sArticleID = null, $sAttributeID = null, \StructType\OXERPSort $oXERPSort = null, $iStart = null, $iCount = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSArticleID($sArticleID)
            ->setSAttributeID($sAttributeID)
            ->setOXERPSort($oXERPSort)
            ->setIStart($iStart)
            ->setICount($iCount);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetArticleAttributes
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sArticleID value
     * @return string|null
     */
    public function getSArticleID()
    {
        return $this->sArticleID;
    }
    /**
     * Set sArticleID value
     * @param string $sArticleID
     * @return \StructType\OXERPGetArticleAttributes
     */
    public function setSArticleID($sArticleID = null)
    {
        // validation for constraint: string
        if (!is_null($sArticleID) && !is_string($sArticleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sArticleID, true), gettype($sArticleID)), __LINE__);
        }
        $this->sArticleID = $sArticleID;
        return $this;
    }
    /**
     * Get sAttributeID value
     * @return string|null
     */
    public function getSAttributeID()
    {
        return $this->sAttributeID;
    }
    /**
     * Set sAttributeID value
     * @param string $sAttributeID
     * @return \StructType\OXERPGetArticleAttributes
     */
    public function setSAttributeID($sAttributeID = null)
    {
        // validation for constraint: string
        if (!is_null($sAttributeID) && !is_string($sAttributeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAttributeID, true), gettype($sAttributeID)), __LINE__);
        }
        $this->sAttributeID = $sAttributeID;
        return $this;
    }
    /**
     * Get OXERPSort value
     * @return \StructType\OXERPSort|null
     */
    public function getOXERPSort()
    {
        return $this->OXERPSort;
    }
    /**
     * Set OXERPSort value
     * @param \StructType\OXERPSort $oXERPSort
     * @return \StructType\OXERPGetArticleAttributes
     */
    public function setOXERPSort(\StructType\OXERPSort $oXERPSort = null)
    {
        $this->OXERPSort = $oXERPSort;
        return $this;
    }
    /**
     * Get iStart value
     * @return int|null
     */
    public function getIStart()
    {
        return $this->iStart;
    }
    /**
     * Set iStart value
     * @param int $iStart
     * @return \StructType\OXERPGetArticleAttributes
     */
    public function setIStart($iStart = null)
    {
        // validation for constraint: int
        if (!is_null($iStart) && !(is_int($iStart) || ctype_digit($iStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iStart, true), gettype($iStart)), __LINE__);
        }
        $this->iStart = $iStart;
        return $this;
    }
    /**
     * Get iCount value
     * @return int|null
     */
    public function getICount()
    {
        return $this->iCount;
    }
    /**
     * Set iCount value
     * @param int $iCount
     * @return \StructType\OXERPGetArticleAttributes
     */
    public function setICount($iCount = null)
    {
        // validation for constraint: int
        if (!is_null($iCount) && !(is_int($iCount) || ctype_digit($iCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iCount, true), gettype($iCount)), __LINE__);
        }
        $this->iCount = $iCount;
        return $this;
    }
}
