<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPCallPlugin StructType
 * @subpackage Structs
 */
class OXERPCallPlugin extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sPluginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sPluginName;
    /**
     * The aRequestData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOXERPType
     */
    public $aRequestData;
    /**
     * Constructor method for OXERPCallPlugin
     * @uses OXERPCallPlugin::setSSessionID()
     * @uses OXERPCallPlugin::setSPluginName()
     * @uses OXERPCallPlugin::setARequestData()
     * @param string $sSessionID
     * @param string $sPluginName
     * @param \ArrayType\ArrayOfOXERPType $aRequestData
     */
    public function __construct($sSessionID = null, $sPluginName = null, \ArrayType\ArrayOfOXERPType $aRequestData = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSPluginName($sPluginName)
            ->setARequestData($aRequestData);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPCallPlugin
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sPluginName value
     * @return string|null
     */
    public function getSPluginName()
    {
        return $this->sPluginName;
    }
    /**
     * Set sPluginName value
     * @param string $sPluginName
     * @return \StructType\OXERPCallPlugin
     */
    public function setSPluginName($sPluginName = null)
    {
        // validation for constraint: string
        if (!is_null($sPluginName) && !is_string($sPluginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPluginName, true), gettype($sPluginName)), __LINE__);
        }
        $this->sPluginName = $sPluginName;
        return $this;
    }
    /**
     * Get aRequestData value
     * @return \ArrayType\ArrayOfOXERPType|null
     */
    public function getARequestData()
    {
        return $this->aRequestData;
    }
    /**
     * Set aRequestData value
     * @param \ArrayType\ArrayOfOXERPType $aRequestData
     * @return \StructType\OXERPCallPlugin
     */
    public function setARequestData(\ArrayType\ArrayOfOXERPType $aRequestData = null)
    {
        $this->aRequestData = $aRequestData;
        return $this;
    }
}
