<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OXERPS ServiceType
 * @subpackage Services
 */
class OXERPS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OXERPSetUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetUser $parameters
     * @return \StructType\OXERPSetUserResponse|bool
     */
    public function OXERPSetUser(\StructType\OXERPSetUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetCategory $parameters
     * @return \StructType\OXERPSetCategoryResponse|bool
     */
    public function OXERPSetCategory(\StructType\OXERPSetCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticle $parameters
     * @return \StructType\OXERPSetArticleResponse|bool
     */
    public function OXERPSetArticle(\StructType\OXERPSetArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArtExtends
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArtExtends $parameters
     * @return \StructType\OXERPSetArtExtendsResponse|bool
     */
    public function OXERPSetArtExtends(\StructType\OXERPSetArtExtends $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArtExtends($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleStock $parameters
     * @return \StructType\OXERPSetArticleStockResponse|bool
     */
    public function OXERPSetArticleStock(\StructType\OXERPSetArticleStock $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleCategory $parameters
     * @return \StructType\OXERPSetArticleCategoryResponse|bool
     */
    public function OXERPSetArticleCategory(\StructType\OXERPSetArticleCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetObject2Category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetObject2Category $parameters
     * @return \StructType\OXERPSetObject2CategoryResponse|bool
     */
    public function OXERPSetObject2Category(\StructType\OXERPSetObject2Category $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetObject2Category($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleAction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleAction $parameters
     * @return \StructType\OXERPSetArticleActionResponse|bool
     */
    public function OXERPSetArticleAction(\StructType\OXERPSetArticleAction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleAction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleCrossselling
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleCrossselling $parameters
     * @return \StructType\OXERPSetArticleCrosssellingResponse|bool
     */
    public function OXERPSetArticleCrossselling(\StructType\OXERPSetArticleCrossselling $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleCrossselling($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleScalePrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleScalePrice $parameters
     * @return \StructType\OXERPSetArticleScalePriceResponse|bool
     */
    public function OXERPSetArticleScalePrice(\StructType\OXERPSetArticleScalePrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleScalePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleAccessoire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleAccessoire $parameters
     * @return \StructType\OXERPSetArticleAccessoireResponse|bool
     */
    public function OXERPSetArticleAccessoire(\StructType\OXERPSetArticleAccessoire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleAccessoire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetOrder $parameters
     * @return \StructType\OXERPSetOrderResponse|bool
     */
    public function OXERPSetOrder(\StructType\OXERPSetOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetOrderArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetOrderArticle $parameters
     * @return \StructType\OXERPSetOrderArticleResponse|bool
     */
    public function OXERPSetOrderArticle(\StructType\OXERPSetOrderArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetOrderArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetOrderStatus $parameters
     * @return \StructType\OXERPSetOrderStatusResponse|bool
     */
    public function OXERPSetOrderStatus(\StructType\OXERPSetOrderStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetCountry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetCountry $parameters
     * @return \StructType\OXERPSetCountryResponse|bool
     */
    public function OXERPSetCountry(\StructType\OXERPSetCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetVendor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetVendor $parameters
     * @return \StructType\OXERPSetVendorResponse|bool
     */
    public function OXERPSetVendor(\StructType\OXERPSetVendor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetVendor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleVendor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleVendor $parameters
     * @return \StructType\OXERPSetArticleVendorResponse|bool
     */
    public function OXERPSetArticleVendor(\StructType\OXERPSetArticleVendor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleVendor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetManufacturer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetManufacturer $parameters
     * @return \StructType\OXERPSetManufacturerResponse|bool
     */
    public function OXERPSetManufacturer(\StructType\OXERPSetManufacturer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetManufacturer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleManufacturer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleManufacturer $parameters
     * @return \StructType\OXERPSetArticleManufacturerResponse|bool
     */
    public function OXERPSetArticleManufacturer(\StructType\OXERPSetArticleManufacturer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleManufacturer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetMainArticleCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetMainArticleCategory $parameters
     * @return \StructType\OXERPSetMainArticleCategoryResponse|bool
     */
    public function OXERPSetMainArticleCategory(\StructType\OXERPSetMainArticleCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetMainArticleCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetAttribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetAttribute $parameters
     * @return \StructType\OXERPSetAttributeResponse|bool
     */
    public function OXERPSetAttribute(\StructType\OXERPSetAttribute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetAttribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleAttributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleAttributes $parameters
     * @return \StructType\OXERPSetArticleAttributesResponse|bool
     */
    public function OXERPSetArticleAttributes(\StructType\OXERPSetArticleAttributes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleAttributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetContent $parameters
     * @return \StructType\OXERPSetContentResponse|bool
     */
    public function OXERPSetContent(\StructType\OXERPSetContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetArticleFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetArticleFile $parameters
     * @return \StructType\OXERPSetArticleFileResponse|bool
     */
    public function OXERPSetArticleFile(\StructType\OXERPSetArticleFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetArticleFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPSetOrderArticleFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPSetOrderArticleFile $parameters
     * @return \StructType\OXERPSetOrderArticleFileResponse|bool
     */
    public function OXERPSetOrderArticleFile(\StructType\OXERPSetOrderArticleFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPSetOrderArticleFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OXERPSetArtExtendsResponse|\StructType\OXERPSetArticleAccessoireResponse|\StructType\OXERPSetArticleActionResponse|\StructType\OXERPSetArticleAttributesResponse|\StructType\OXERPSetArticleCategoryResponse|\StructType\OXERPSetArticleCrosssellingResponse|\StructType\OXERPSetArticleFileResponse|\StructType\OXERPSetArticleManufacturerResponse|\StructType\OXERPSetArticleResponse|\StructType\OXERPSetArticleScalePriceResponse|\StructType\OXERPSetArticleStockResponse|\StructType\OXERPSetArticleVendorResponse|\StructType\OXERPSetAttributeResponse|\StructType\OXERPSetCategoryResponse|\StructType\OXERPSetContentResponse|\StructType\OXERPSetCountryResponse|\StructType\OXERPSetMainArticleCategoryResponse|\StructType\OXERPSetManufacturerResponse|\StructType\OXERPSetObject2CategoryResponse|\StructType\OXERPSetOrderArticleFileResponse|\StructType\OXERPSetOrderArticleResponse|\StructType\OXERPSetOrderResponse|\StructType\OXERPSetOrderStatusResponse|\StructType\OXERPSetUserResponse|\StructType\OXERPSetVendorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
