<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OXERPL ServiceType
 * @subpackage Services
 */
class OXERPL extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OXERPLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPLogin $parameters
     * @return \StructType\OXERPLoginResponse|bool
     */
    public function OXERPLogin(\StructType\OXERPLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OXERPLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
