<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OXERPD ServiceType
 * @subpackage Services
 */
class OXERPD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OXERPDeleteUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteUser $parameters
     * @return \StructType\OXERPDeleteUserResponse|bool
     */
    public function OXERPDeleteUser(\StructType\OXERPDeleteUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteUsers $parameters
     * @return \StructType\OXERPDeleteUsersResponse|bool
     */
    public function OXERPDeleteUsers(\StructType\OXERPDeleteUsers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteCategory $parameters
     * @return \StructType\OXERPDeleteCategoryResponse|bool
     */
    public function OXERPDeleteCategory(\StructType\OXERPDeleteCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteCategories $parameters
     * @return \StructType\OXERPDeleteCategoriesResponse|bool
     */
    public function OXERPDeleteCategories(\StructType\OXERPDeleteCategories $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticle $parameters
     * @return \StructType\OXERPDeleteArticleResponse|bool
     */
    public function OXERPDeleteArticle(\StructType\OXERPDeleteArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticleCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticleCategory $parameters
     * @return \StructType\OXERPDeleteArticleCategoryResponse|bool
     */
    public function OXERPDeleteArticleCategory(\StructType\OXERPDeleteArticleCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticleCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteOrderArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteOrderArticle $parameters
     * @return \StructType\OXERPDeleteOrderArticleResponse|bool
     */
    public function OXERPDeleteOrderArticle(\StructType\OXERPDeleteOrderArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteOrderArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteAccessoireArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteAccessoireArticle $parameters
     * @return \StructType\OXERPDeleteAccessoireArticleResponse|bool
     */
    public function OXERPDeleteAccessoireArticle(\StructType\OXERPDeleteAccessoireArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteAccessoireArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticleScalePrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticleScalePrice $parameters
     * @return \StructType\OXERPDeleteArticleScalePriceResponse|bool
     */
    public function OXERPDeleteArticleScalePrice(\StructType\OXERPDeleteArticleScalePrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticleScalePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticleCrossselling
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticleCrossselling $parameters
     * @return \StructType\OXERPDeleteArticleCrosssellingResponse|bool
     */
    public function OXERPDeleteArticleCrossselling(\StructType\OXERPDeleteArticleCrossselling $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticleCrossselling($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteActionsArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteActionsArticle $parameters
     * @return \StructType\OXERPDeleteActionsArticleResponse|bool
     */
    public function OXERPDeleteActionsArticle(\StructType\OXERPDeleteActionsArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteActionsArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticles $parameters
     * @return \StructType\OXERPDeleteArticlesResponse|bool
     */
    public function OXERPDeleteArticles(\StructType\OXERPDeleteArticles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteObject2Category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteObject2Category $parameters
     * @return \StructType\OXERPDeleteObject2CategoryResponse|bool
     */
    public function OXERPDeleteObject2Category(\StructType\OXERPDeleteObject2Category $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteObject2Category($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteOrder $parameters
     * @return \StructType\OXERPDeleteOrderResponse|bool
     */
    public function OXERPDeleteOrder(\StructType\OXERPDeleteOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteOrders $parameters
     * @return \StructType\OXERPDeleteOrdersResponse|bool
     */
    public function OXERPDeleteOrders(\StructType\OXERPDeleteOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteCountry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteCountry $parameters
     * @return \StructType\OXERPDeleteCountryResponse|bool
     */
    public function OXERPDeleteCountry(\StructType\OXERPDeleteCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteVendor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteVendor $parameters
     * @return \StructType\OXERPDeleteVendorResponse|bool
     */
    public function OXERPDeleteVendor(\StructType\OXERPDeleteVendor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteVendor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteVendors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteVendors $parameters
     * @return \StructType\OXERPDeleteVendorsResponse|bool
     */
    public function OXERPDeleteVendors(\StructType\OXERPDeleteVendors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteVendors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteManufacturer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteManufacturer $parameters
     * @return \StructType\OXERPDeleteManufacturerResponse|bool
     */
    public function OXERPDeleteManufacturer(\StructType\OXERPDeleteManufacturer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteManufacturer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteManufacturers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteManufacturers $parameters
     * @return \StructType\OXERPDeleteManufacturersResponse|bool
     */
    public function OXERPDeleteManufacturers(\StructType\OXERPDeleteManufacturers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteManufacturers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteContent $parameters
     * @return \StructType\OXERPDeleteContentResponse|bool
     */
    public function OXERPDeleteContent(\StructType\OXERPDeleteContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticleFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticleFile $parameters
     * @return \StructType\OXERPDeleteArticleFileResponse|bool
     */
    public function OXERPDeleteArticleFile(\StructType\OXERPDeleteArticleFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticleFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteArticleFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteArticleFiles $parameters
     * @return \StructType\OXERPDeleteArticleFilesResponse|bool
     */
    public function OXERPDeleteArticleFiles(\StructType\OXERPDeleteArticleFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteArticleFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPDeleteOrderArticleFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPDeleteOrderArticleFile $parameters
     * @return \StructType\OXERPDeleteOrderArticleFileResponse|bool
     */
    public function OXERPDeleteOrderArticleFile(\StructType\OXERPDeleteOrderArticleFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPDeleteOrderArticleFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OXERPDeleteAccessoireArticleResponse|\StructType\OXERPDeleteActionsArticleResponse|\StructType\OXERPDeleteArticleCategoryResponse|\StructType\OXERPDeleteArticleCrosssellingResponse|\StructType\OXERPDeleteArticleFileResponse|\StructType\OXERPDeleteArticleFilesResponse|\StructType\OXERPDeleteArticleResponse|\StructType\OXERPDeleteArticleScalePriceResponse|\StructType\OXERPDeleteArticlesResponse|\StructType\OXERPDeleteCategoriesResponse|\StructType\OXERPDeleteCategoryResponse|\StructType\OXERPDeleteContentResponse|\StructType\OXERPDeleteCountryResponse|\StructType\OXERPDeleteManufacturerResponse|\StructType\OXERPDeleteManufacturersResponse|\StructType\OXERPDeleteObject2CategoryResponse|\StructType\OXERPDeleteOrderArticleFileResponse|\StructType\OXERPDeleteOrderArticleResponse|\StructType\OXERPDeleteOrderResponse|\StructType\OXERPDeleteOrdersResponse|\StructType\OXERPDeleteUserResponse|\StructType\OXERPDeleteUsersResponse|\StructType\OXERPDeleteVendorResponse|\StructType\OXERPDeleteVendorsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
