<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPLogin StructType
 * @subpackage Structs
 */
class OXERPLogin extends AbstractStructBase
{
    /**
     * The iShopID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $iShopID;
    /**
     * The iLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $iLanguage;
    /**
     * The sUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserName;
    /**
     * The sPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sPassword;
    /**
     * Constructor method for OXERPLogin
     * @uses OXERPLogin::setIShopID()
     * @uses OXERPLogin::setILanguage()
     * @uses OXERPLogin::setSUserName()
     * @uses OXERPLogin::setSPassword()
     * @param int $iShopID
     * @param int $iLanguage
     * @param string $sUserName
     * @param string $sPassword
     */
    public function __construct($iShopID = null, $iLanguage = null, $sUserName = null, $sPassword = null)
    {
        $this
            ->setIShopID($iShopID)
            ->setILanguage($iLanguage)
            ->setSUserName($sUserName)
            ->setSPassword($sPassword);
    }
    /**
     * Get iShopID value
     * @return int
     */
    public function getIShopID()
    {
        return $this->iShopID;
    }
    /**
     * Set iShopID value
     * @param int $iShopID
     * @return \StructType\OXERPLogin
     */
    public function setIShopID($iShopID = null)
    {
        // validation for constraint: int
        if (!is_null($iShopID) && !(is_int($iShopID) || ctype_digit($iShopID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iShopID, true), gettype($iShopID)), __LINE__);
        }
        $this->iShopID = $iShopID;
        return $this;
    }
    /**
     * Get iLanguage value
     * @return int
     */
    public function getILanguage()
    {
        return $this->iLanguage;
    }
    /**
     * Set iLanguage value
     * @param int $iLanguage
     * @return \StructType\OXERPLogin
     */
    public function setILanguage($iLanguage = null)
    {
        // validation for constraint: int
        if (!is_null($iLanguage) && !(is_int($iLanguage) || ctype_digit($iLanguage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iLanguage, true), gettype($iLanguage)), __LINE__);
        }
        $this->iLanguage = $iLanguage;
        return $this;
    }
    /**
     * Get sUserName value
     * @return string|null
     */
    public function getSUserName()
    {
        return $this->sUserName;
    }
    /**
     * Set sUserName value
     * @param string $sUserName
     * @return \StructType\OXERPLogin
     */
    public function setSUserName($sUserName = null)
    {
        // validation for constraint: string
        if (!is_null($sUserName) && !is_string($sUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserName, true), gettype($sUserName)), __LINE__);
        }
        $this->sUserName = $sUserName;
        return $this;
    }
    /**
     * Get sPassword value
     * @return string|null
     */
    public function getSPassword()
    {
        return $this->sPassword;
    }
    /**
     * Set sPassword value
     * @param string $sPassword
     * @return \StructType\OXERPLogin
     */
    public function setSPassword($sPassword = null)
    {
        // validation for constraint: string
        if (!is_null($sPassword) && !is_string($sPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPassword, true), gettype($sPassword)), __LINE__);
        }
        $this->sPassword = $sPassword;
        return $this;
    }
}
