<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetVendorArticles StructType
 * @subpackage Structs
 */
class OXERPGetVendorArticles extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sVendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sVendorID;
    /**
     * The OXERPSort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXERPSort
     */
    public $OXERPSort;
    /**
     * The iStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iStart;
    /**
     * The iCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iCount;
    /**
     * Constructor method for OXERPGetVendorArticles
     * @uses OXERPGetVendorArticles::setSSessionID()
     * @uses OXERPGetVendorArticles::setSVendorID()
     * @uses OXERPGetVendorArticles::setOXERPSort()
     * @uses OXERPGetVendorArticles::setIStart()
     * @uses OXERPGetVendorArticles::setICount()
     * @param string $sSessionID
     * @param string $sVendorID
     * @param \StructType\OXERPSort $oXERPSort
     * @param int $iStart
     * @param int $iCount
     */
    public function __construct($sSessionID = null, $sVendorID = null, \StructType\OXERPSort $oXERPSort = null, $iStart = null, $iCount = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSVendorID($sVendorID)
            ->setOXERPSort($oXERPSort)
            ->setIStart($iStart)
            ->setICount($iCount);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetVendorArticles
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sVendorID value
     * @return string|null
     */
    public function getSVendorID()
    {
        return $this->sVendorID;
    }
    /**
     * Set sVendorID value
     * @param string $sVendorID
     * @return \StructType\OXERPGetVendorArticles
     */
    public function setSVendorID($sVendorID = null)
    {
        // validation for constraint: string
        if (!is_null($sVendorID) && !is_string($sVendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sVendorID, true), gettype($sVendorID)), __LINE__);
        }
        $this->sVendorID = $sVendorID;
        return $this;
    }
    /**
     * Get OXERPSort value
     * @return \StructType\OXERPSort|null
     */
    public function getOXERPSort()
    {
        return $this->OXERPSort;
    }
    /**
     * Set OXERPSort value
     * @param \StructType\OXERPSort $oXERPSort
     * @return \StructType\OXERPGetVendorArticles
     */
    public function setOXERPSort(\StructType\OXERPSort $oXERPSort = null)
    {
        $this->OXERPSort = $oXERPSort;
        return $this;
    }
    /**
     * Get iStart value
     * @return int|null
     */
    public function getIStart()
    {
        return $this->iStart;
    }
    /**
     * Set iStart value
     * @param int $iStart
     * @return \StructType\OXERPGetVendorArticles
     */
    public function setIStart($iStart = null)
    {
        // validation for constraint: int
        if (!is_null($iStart) && !(is_int($iStart) || ctype_digit($iStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iStart, true), gettype($iStart)), __LINE__);
        }
        $this->iStart = $iStart;
        return $this;
    }
    /**
     * Get iCount value
     * @return int|null
     */
    public function getICount()
    {
        return $this->iCount;
    }
    /**
     * Set iCount value
     * @param int $iCount
     * @return \StructType\OXERPGetVendorArticles
     */
    public function setICount($iCount = null)
    {
        // validation for constraint: int
        if (!is_null($iCount) && !(is_int($iCount) || ctype_digit($iCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iCount, true), gettype($iCount)), __LINE__);
        }
        $this->iCount = $iCount;
        return $this;
    }
}
