<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetObject2Category StructType
 * @subpackage Structs
 */
class OXERPGetObject2Category extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sObject2CategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sObject2CategoryID;
    /**
     * The sArticleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sArticleID;
    /**
     * The sCategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCategoryID;
    /**
     * The OXERPSort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXERPSort
     */
    public $OXERPSort;
    /**
     * The iStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iStart;
    /**
     * The iCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $iCount;
    /**
     * Constructor method for OXERPGetObject2Category
     * @uses OXERPGetObject2Category::setSSessionID()
     * @uses OXERPGetObject2Category::setSObject2CategoryID()
     * @uses OXERPGetObject2Category::setSArticleID()
     * @uses OXERPGetObject2Category::setSCategoryID()
     * @uses OXERPGetObject2Category::setOXERPSort()
     * @uses OXERPGetObject2Category::setIStart()
     * @uses OXERPGetObject2Category::setICount()
     * @param string $sSessionID
     * @param string $sObject2CategoryID
     * @param string $sArticleID
     * @param string $sCategoryID
     * @param \StructType\OXERPSort $oXERPSort
     * @param int $iStart
     * @param int $iCount
     */
    public function __construct($sSessionID = null, $sObject2CategoryID = null, $sArticleID = null, $sCategoryID = null, \StructType\OXERPSort $oXERPSort = null, $iStart = null, $iCount = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSObject2CategoryID($sObject2CategoryID)
            ->setSArticleID($sArticleID)
            ->setSCategoryID($sCategoryID)
            ->setOXERPSort($oXERPSort)
            ->setIStart($iStart)
            ->setICount($iCount);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetObject2Category
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sObject2CategoryID value
     * @return string|null
     */
    public function getSObject2CategoryID()
    {
        return $this->sObject2CategoryID;
    }
    /**
     * Set sObject2CategoryID value
     * @param string $sObject2CategoryID
     * @return \StructType\OXERPGetObject2Category
     */
    public function setSObject2CategoryID($sObject2CategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($sObject2CategoryID) && !is_string($sObject2CategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sObject2CategoryID, true), gettype($sObject2CategoryID)), __LINE__);
        }
        $this->sObject2CategoryID = $sObject2CategoryID;
        return $this;
    }
    /**
     * Get sArticleID value
     * @return string|null
     */
    public function getSArticleID()
    {
        return $this->sArticleID;
    }
    /**
     * Set sArticleID value
     * @param string $sArticleID
     * @return \StructType\OXERPGetObject2Category
     */
    public function setSArticleID($sArticleID = null)
    {
        // validation for constraint: string
        if (!is_null($sArticleID) && !is_string($sArticleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sArticleID, true), gettype($sArticleID)), __LINE__);
        }
        $this->sArticleID = $sArticleID;
        return $this;
    }
    /**
     * Get sCategoryID value
     * @return string|null
     */
    public function getSCategoryID()
    {
        return $this->sCategoryID;
    }
    /**
     * Set sCategoryID value
     * @param string $sCategoryID
     * @return \StructType\OXERPGetObject2Category
     */
    public function setSCategoryID($sCategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($sCategoryID) && !is_string($sCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCategoryID, true), gettype($sCategoryID)), __LINE__);
        }
        $this->sCategoryID = $sCategoryID;
        return $this;
    }
    /**
     * Get OXERPSort value
     * @return \StructType\OXERPSort|null
     */
    public function getOXERPSort()
    {
        return $this->OXERPSort;
    }
    /**
     * Set OXERPSort value
     * @param \StructType\OXERPSort $oXERPSort
     * @return \StructType\OXERPGetObject2Category
     */
    public function setOXERPSort(\StructType\OXERPSort $oXERPSort = null)
    {
        $this->OXERPSort = $oXERPSort;
        return $this;
    }
    /**
     * Get iStart value
     * @return int|null
     */
    public function getIStart()
    {
        return $this->iStart;
    }
    /**
     * Set iStart value
     * @param int $iStart
     * @return \StructType\OXERPGetObject2Category
     */
    public function setIStart($iStart = null)
    {
        // validation for constraint: int
        if (!is_null($iStart) && !(is_int($iStart) || ctype_digit($iStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iStart, true), gettype($iStart)), __LINE__);
        }
        $this->iStart = $iStart;
        return $this;
    }
    /**
     * Get iCount value
     * @return int|null
     */
    public function getICount()
    {
        return $this->iCount;
    }
    /**
     * Set iCount value
     * @param int $iCount
     * @return \StructType\OXERPGetObject2Category
     */
    public function setICount($iCount = null)
    {
        // validation for constraint: int
        if (!is_null($iCount) && !(is_int($iCount) || ctype_digit($iCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iCount, true), gettype($iCount)), __LINE__);
        }
        $this->iCount = $iCount;
        return $this;
    }
}
