<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetCountry StructType
 * @subpackage Structs
 */
class OXERPGetCountry extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sCountryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCountryID;
    /**
     * Constructor method for OXERPGetCountry
     * @uses OXERPGetCountry::setSSessionID()
     * @uses OXERPGetCountry::setSCountryID()
     * @param string $sSessionID
     * @param string $sCountryID
     */
    public function __construct($sSessionID = null, $sCountryID = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSCountryID($sCountryID);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetCountry
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sCountryID value
     * @return string|null
     */
    public function getSCountryID()
    {
        return $this->sCountryID;
    }
    /**
     * Set sCountryID value
     * @param string $sCountryID
     * @return \StructType\OXERPGetCountry
     */
    public function setSCountryID($sCountryID = null)
    {
        // validation for constraint: string
        if (!is_null($sCountryID) && !is_string($sCountryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCountryID, true), gettype($sCountryID)), __LINE__);
        }
        $this->sCountryID = $sCountryID;
        return $this;
    }
}
