<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXERPGetArtExtends StructType
 * @subpackage Structs
 */
class OXERPGetArtExtends extends AbstractStructBase
{
    /**
     * The sSessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSessionID;
    /**
     * The sArticleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sArticleID;
    /**
     * Constructor method for OXERPGetArtExtends
     * @uses OXERPGetArtExtends::setSSessionID()
     * @uses OXERPGetArtExtends::setSArticleID()
     * @param string $sSessionID
     * @param string $sArticleID
     */
    public function __construct($sSessionID = null, $sArticleID = null)
    {
        $this
            ->setSSessionID($sSessionID)
            ->setSArticleID($sArticleID);
    }
    /**
     * Get sSessionID value
     * @return string|null
     */
    public function getSSessionID()
    {
        return $this->sSessionID;
    }
    /**
     * Set sSessionID value
     * @param string $sSessionID
     * @return \StructType\OXERPGetArtExtends
     */
    public function setSSessionID($sSessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sSessionID) && !is_string($sSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSessionID, true), gettype($sSessionID)), __LINE__);
        }
        $this->sSessionID = $sSessionID;
        return $this;
    }
    /**
     * Get sArticleID value
     * @return string|null
     */
    public function getSArticleID()
    {
        return $this->sArticleID;
    }
    /**
     * Set sArticleID value
     * @param string $sArticleID
     * @return \StructType\OXERPGetArtExtends
     */
    public function setSArticleID($sArticleID = null)
    {
        // validation for constraint: string
        if (!is_null($sArticleID) && !is_string($sArticleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sArticleID, true), gettype($sArticleID)), __LINE__);
        }
        $this->sArticleID = $sArticleID;
        return $this;
    }
}
