<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OXERPG ServiceType
 * @subpackage Services
 */
class OXERPG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OXERPGetUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetUser $parameters
     * @return \StructType\OXERPGetUserResponse|bool
     */
    public function OXERPGetUser(\StructType\OXERPGetUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetUsers $parameters
     * @return \StructType\OXERPGetUsersResponse|bool
     */
    public function OXERPGetUsers(\StructType\OXERPGetUsers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetCategory $parameters
     * @return \StructType\OXERPGetCategoryResponse|bool
     */
    public function OXERPGetCategory(\StructType\OXERPGetCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetCategories $parameters
     * @return \StructType\OXERPGetCategoriesResponse|bool
     */
    public function OXERPGetCategories(\StructType\OXERPGetCategories $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticle $parameters
     * @return \StructType\OXERPGetArticleResponse|bool
     */
    public function OXERPGetArticle(\StructType\OXERPGetArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArtExtends
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArtExtends $parameters
     * @return \StructType\OXERPGetArtExtendsResponse|bool
     */
    public function OXERPGetArtExtends(\StructType\OXERPGetArtExtends $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArtExtends($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticles $parameters
     * @return \StructType\OXERPGetArticlesResponse|bool
     */
    public function OXERPGetArticles(\StructType\OXERPGetArticles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleStock $parameters
     * @return \StructType\OXERPGetArticleStockResponse|bool
     */
    public function OXERPGetArticleStock(\StructType\OXERPGetArticleStock $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleCategory $parameters
     * @return \StructType\OXERPGetArticleCategoryResponse|bool
     */
    public function OXERPGetArticleCategory(\StructType\OXERPGetArticleCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetObject2Category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetObject2Category $parameters
     * @return \StructType\OXERPGetObject2CategoryResponse|bool
     */
    public function OXERPGetObject2Category(\StructType\OXERPGetObject2Category $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetObject2Category($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleAction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleAction $parameters
     * @return \StructType\OXERPGetArticleActionResponse|bool
     */
    public function OXERPGetArticleAction(\StructType\OXERPGetArticleAction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleAction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleCrossselling
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleCrossselling $parameters
     * @return \StructType\OXERPGetArticleCrosssellingResponse|bool
     */
    public function OXERPGetArticleCrossselling(\StructType\OXERPGetArticleCrossselling $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleCrossselling($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleScalePrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleScalePrice $parameters
     * @return \StructType\OXERPGetArticleScalePriceResponse|bool
     */
    public function OXERPGetArticleScalePrice(\StructType\OXERPGetArticleScalePrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleScalePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleAccessoire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleAccessoire $parameters
     * @return \StructType\OXERPGetArticleAccessoireResponse|bool
     */
    public function OXERPGetArticleAccessoire(\StructType\OXERPGetArticleAccessoire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleAccessoire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetOrder $parameters
     * @return \StructType\OXERPGetOrderResponse|bool
     */
    public function OXERPGetOrder(\StructType\OXERPGetOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetOrders $parameters
     * @return \StructType\OXERPGetOrdersResponse|bool
     */
    public function OXERPGetOrders(\StructType\OXERPGetOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetOrderArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetOrderArticle $parameters
     * @return \StructType\OXERPGetOrderArticleResponse|bool
     */
    public function OXERPGetOrderArticle(\StructType\OXERPGetOrderArticle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetOrderArticle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetCountry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetCountry $parameters
     * @return \StructType\OXERPGetCountryResponse|bool
     */
    public function OXERPGetCountry(\StructType\OXERPGetCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetCountries $parameters
     * @return \StructType\OXERPGetCountriesResponse|bool
     */
    public function OXERPGetCountries(\StructType\OXERPGetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetVendor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetVendor $parameters
     * @return \StructType\OXERPGetVendorResponse|bool
     */
    public function OXERPGetVendor(\StructType\OXERPGetVendor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetVendor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetVendors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetVendors $parameters
     * @return \StructType\OXERPGetVendorsResponse|bool
     */
    public function OXERPGetVendors(\StructType\OXERPGetVendors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetVendors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetManufacturer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetManufacturer $parameters
     * @return \StructType\OXERPGetManufacturerResponse|bool
     */
    public function OXERPGetManufacturer(\StructType\OXERPGetManufacturer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetManufacturer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetManufacturers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetManufacturers $parameters
     * @return \StructType\OXERPGetManufacturersResponse|bool
     */
    public function OXERPGetManufacturers(\StructType\OXERPGetManufacturers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetManufacturers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleVendor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleVendor $parameters
     * @return \StructType\OXERPGetArticleVendorResponse|bool
     */
    public function OXERPGetArticleVendor(\StructType\OXERPGetArticleVendor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleVendor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleVendors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleVendors $parameters
     * @return \StructType\OXERPGetArticleVendorsResponse|bool
     */
    public function OXERPGetArticleVendors(\StructType\OXERPGetArticleVendors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleVendors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetVendorArticles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetVendorArticles $parameters
     * @return \StructType\OXERPGetVendorArticlesResponse|bool
     */
    public function OXERPGetVendorArticles(\StructType\OXERPGetVendorArticles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetVendorArticles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleManufacturer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleManufacturer $parameters
     * @return \StructType\OXERPGetArticleManufacturerResponse|bool
     */
    public function OXERPGetArticleManufacturer(\StructType\OXERPGetArticleManufacturer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleManufacturer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleManufacturers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleManufacturers $parameters
     * @return \StructType\OXERPGetArticleManufacturersResponse|bool
     */
    public function OXERPGetArticleManufacturers(\StructType\OXERPGetArticleManufacturers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleManufacturers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetManufacturerArticles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetManufacturerArticles $parameters
     * @return \StructType\OXERPGetManufacturerArticlesResponse|bool
     */
    public function OXERPGetManufacturerArticles(\StructType\OXERPGetManufacturerArticles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetManufacturerArticles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetAttributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetAttributes $parameters
     * @return \StructType\OXERPGetAttributesResponse|bool
     */
    public function OXERPGetAttributes(\StructType\OXERPGetAttributes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetAttributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleAttributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleAttributes $parameters
     * @return \StructType\OXERPGetArticleAttributesResponse|bool
     */
    public function OXERPGetArticleAttributes(\StructType\OXERPGetArticleAttributes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleAttributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetContent $parameters
     * @return \StructType\OXERPGetContentResponse|bool
     */
    public function OXERPGetContent(\StructType\OXERPGetContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleFile $parameters
     * @return \StructType\OXERPGetArticleFileResponse|bool
     */
    public function OXERPGetArticleFile(\StructType\OXERPGetArticleFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetArticleFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetArticleFiles $parameters
     * @return \StructType\OXERPGetArticleFilesResponse|bool
     */
    public function OXERPGetArticleFiles(\StructType\OXERPGetArticleFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetArticleFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetOrderArticleFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetOrderArticleFile $parameters
     * @return \StructType\OXERPGetOrderArticleFileResponse|bool
     */
    public function OXERPGetOrderArticleFile(\StructType\OXERPGetOrderArticleFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetOrderArticleFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OXERPGetOrderArticleFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPGetOrderArticleFiles $parameters
     * @return \StructType\OXERPGetOrderArticleFilesResponse|bool
     */
    public function OXERPGetOrderArticleFiles(\StructType\OXERPGetOrderArticleFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPGetOrderArticleFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OXERPGetArtExtendsResponse|\StructType\OXERPGetArticleAccessoireResponse|\StructType\OXERPGetArticleActionResponse|\StructType\OXERPGetArticleAttributesResponse|\StructType\OXERPGetArticleCategoryResponse|\StructType\OXERPGetArticleCrosssellingResponse|\StructType\OXERPGetArticleFileResponse|\StructType\OXERPGetArticleFilesResponse|\StructType\OXERPGetArticleManufacturerResponse|\StructType\OXERPGetArticleManufacturersResponse|\StructType\OXERPGetArticleResponse|\StructType\OXERPGetArticleScalePriceResponse|\StructType\OXERPGetArticlesResponse|\StructType\OXERPGetArticleStockResponse|\StructType\OXERPGetArticleVendorResponse|\StructType\OXERPGetArticleVendorsResponse|\StructType\OXERPGetAttributesResponse|\StructType\OXERPGetCategoriesResponse|\StructType\OXERPGetCategoryResponse|\StructType\OXERPGetContentResponse|\StructType\OXERPGetCountriesResponse|\StructType\OXERPGetCountryResponse|\StructType\OXERPGetManufacturerArticlesResponse|\StructType\OXERPGetManufacturerResponse|\StructType\OXERPGetManufacturersResponse|\StructType\OXERPGetObject2CategoryResponse|\StructType\OXERPGetOrderArticleFileResponse|\StructType\OXERPGetOrderArticleFilesResponse|\StructType\OXERPGetOrderArticleResponse|\StructType\OXERPGetOrderResponse|\StructType\OXERPGetOrdersResponse|\StructType\OXERPGetUserResponse|\StructType\OXERPGetUsersResponse|\StructType\OXERPGetVendorArticlesResponse|\StructType\OXERPGetVendorResponse|\StructType\OXERPGetVendorsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
