<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OXERPC ServiceType
 * @subpackage Services
 */
class OXERPC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OXERPCallPlugin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OXERPCallPlugin $parameters
     * @return \StructType\OXERPCallPluginResponse|bool
     */
    public function OXERPCallPlugin(\StructType\OXERPCallPlugin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OXERPCallPlugin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OXERPCallPluginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
