<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Unpost_Job_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Response for Unpost Job Request
 * @subpackage Structs
 */
class Unpost_Job_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Event Reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Posting that was Uposted.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_PostingObjectType[]
     */
    public $Job_Posting_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Unpost_Job_ResponseType
     * @uses Unpost_Job_ResponseType::setEvent_Reference()
     * @uses Unpost_Job_ResponseType::setJob_Posting_Reference()
     * @uses Unpost_Job_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Job_PostingObjectType[] $job_Posting_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, array $job_Posting_Reference = array(), $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setJob_Posting_Reference($job_Posting_Reference)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Unpost_Job_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType[]|null
     */
    public function getJob_Posting_Reference()
    {
        return $this->Job_Posting_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_ReferenceForArrayConstraintsFromSetJob_Posting_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unpost_Job_ResponseTypeJob_Posting_ReferenceItem) {
            // validation for constraint: itemType
            if (!$unpost_Job_ResponseTypeJob_Posting_ReferenceItem instanceof \StructType\Job_PostingObjectType) {
                $invalidValues[] = is_object($unpost_Job_ResponseTypeJob_Posting_ReferenceItem) ? get_class($unpost_Job_ResponseTypeJob_Posting_ReferenceItem) : sprintf('%s(%s)', gettype($unpost_Job_ResponseTypeJob_Posting_ReferenceItem), var_export($unpost_Job_ResponseTypeJob_Posting_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Reference property can only contain items of type \StructType\Job_PostingObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType[] $job_Posting_Reference
     * @return \StructType\Unpost_Job_ResponseType
     */
    public function setJob_Posting_Reference(array $job_Posting_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_ReferenceArrayErrorMessage = self::validateJob_Posting_ReferenceForArrayConstraintsFromSetJob_Posting_Reference($job_Posting_Reference))) {
            throw new \InvalidArgumentException($job_Posting_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Reference = $job_Posting_Reference;
        return $this;
    }
    /**
     * Add item to Job_Posting_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType $item
     * @return \StructType\Unpost_Job_ResponseType
     */
    public function addToJob_Posting_Reference(\StructType\Job_PostingObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_PostingObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Reference property can only contain items of type \StructType\Job_PostingObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Reference[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Unpost_Job_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
