<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Each distribution worktag for a Salary Over the Cap Allocation Detail must belong to a unique costing dimension - the set of worktags assigned for this Salary Over the Cap Allocation Detail includes a costing dimension more than
 * once. | A Grant may not exist in the override worktags entered for the Salary Over the Cap sub-allocation. | The override worktags entered for the Salary Over the Cap sub-allocation do not satisfy the set of required allocation dimensions that have
 * been established in the Maintain Worktag Usage task. | Each Salary Over the Cap Allocation Detail within an Allocation Detail must have its own unique ordering. | Details of the Salary over the Cap allocation, (e.g., a set of allocation dimensions
 * and percentages)
 * @subpackage Structs
 */
class Salary_Over_the_Cap_Costing_Allocation_Detail_DataType extends AbstractStructBase
{
    /**
     * The SOC_Order
     * Meta information extracted from the WSDL
     * - documentation: Orders the allocation detail (e.g., 'a', 'b', 'c', ...). Note that during general ledger costing, any rounding issues resulting from the distributions are reconciled in the last allocation detail.
     * - maxOccurs: 1
     * @var string
     */
    public $SOC_Order;
    /**
     * The SOC_Default_from_Organization_Assignment
     * Meta information extracted from the WSDL
     * - documentation: Select Yes (Y) to indicate that the corresponding percentage should be allocated using the worker's (or position's) default organizational assignments with no overrides. Workday detects if this Request represents a sub-event embedded
     * within a higher-level business process, and if so searches for a possible Assign Organization sub-event which contains proposed assignments.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SOC_Default_from_Organization_Assignment;
    /**
     * The SOC_Costing_Override_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Overriding Company for an Allocation Detail, used for Intercompany Accounting
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $SOC_Costing_Override_Company_Reference;
    /**
     * The SOC_Override_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The costing dimension value(s) to use for the override (e.g., cost center reference, fund reference, etc.).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tenanted_Payroll_WorktagObjectType[]
     */
    public $SOC_Override_Worktag_Reference;
    /**
     * The SOC_Distribution_Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage for the given allocation detail, represented as a decimal value (e.g., .5).
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 9
     * @var float
     */
    public $SOC_Distribution_Percent;
    /**
     * Constructor method for Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     * @uses Salary_Over_the_Cap_Costing_Allocation_Detail_DataType::setSOC_Order()
     * @uses Salary_Over_the_Cap_Costing_Allocation_Detail_DataType::setSOC_Default_from_Organization_Assignment()
     * @uses Salary_Over_the_Cap_Costing_Allocation_Detail_DataType::setSOC_Costing_Override_Company_Reference()
     * @uses Salary_Over_the_Cap_Costing_Allocation_Detail_DataType::setSOC_Override_Worktag_Reference()
     * @uses Salary_Over_the_Cap_Costing_Allocation_Detail_DataType::setSOC_Distribution_Percent()
     * @param string $sOC_Order
     * @param bool $sOC_Default_from_Organization_Assignment
     * @param \StructType\CompanyObjectType $sOC_Costing_Override_Company_Reference
     * @param \StructType\Tenanted_Payroll_WorktagObjectType[] $sOC_Override_Worktag_Reference
     * @param float $sOC_Distribution_Percent
     */
    public function __construct($sOC_Order = null, $sOC_Default_from_Organization_Assignment = null, \StructType\CompanyObjectType $sOC_Costing_Override_Company_Reference = null, array $sOC_Override_Worktag_Reference = array(), $sOC_Distribution_Percent = null)
    {
        $this
            ->setSOC_Order($sOC_Order)
            ->setSOC_Default_from_Organization_Assignment($sOC_Default_from_Organization_Assignment)
            ->setSOC_Costing_Override_Company_Reference($sOC_Costing_Override_Company_Reference)
            ->setSOC_Override_Worktag_Reference($sOC_Override_Worktag_Reference)
            ->setSOC_Distribution_Percent($sOC_Distribution_Percent);
    }
    /**
     * Get SOC_Order value
     * @return string|null
     */
    public function getSOC_Order()
    {
        return $this->SOC_Order;
    }
    /**
     * Set SOC_Order value
     * @param string $sOC_Order
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     */
    public function setSOC_Order($sOC_Order = null)
    {
        // validation for constraint: string
        if (!is_null($sOC_Order) && !is_string($sOC_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sOC_Order, true), gettype($sOC_Order)), __LINE__);
        }
        $this->SOC_Order = $sOC_Order;
        return $this;
    }
    /**
     * Get SOC_Default_from_Organization_Assignment value
     * @return bool|null
     */
    public function getSOC_Default_from_Organization_Assignment()
    {
        return $this->SOC_Default_from_Organization_Assignment;
    }
    /**
     * Set SOC_Default_from_Organization_Assignment value
     * @param bool $sOC_Default_from_Organization_Assignment
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     */
    public function setSOC_Default_from_Organization_Assignment($sOC_Default_from_Organization_Assignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($sOC_Default_from_Organization_Assignment) && !is_bool($sOC_Default_from_Organization_Assignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sOC_Default_from_Organization_Assignment, true), gettype($sOC_Default_from_Organization_Assignment)), __LINE__);
        }
        $this->SOC_Default_from_Organization_Assignment = $sOC_Default_from_Organization_Assignment;
        return $this;
    }
    /**
     * Get SOC_Costing_Override_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getSOC_Costing_Override_Company_Reference()
    {
        return $this->SOC_Costing_Override_Company_Reference;
    }
    /**
     * Set SOC_Costing_Override_Company_Reference value
     * @param \StructType\CompanyObjectType $sOC_Costing_Override_Company_Reference
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     */
    public function setSOC_Costing_Override_Company_Reference(\StructType\CompanyObjectType $sOC_Costing_Override_Company_Reference = null)
    {
        $this->SOC_Costing_Override_Company_Reference = $sOC_Costing_Override_Company_Reference;
        return $this;
    }
    /**
     * Get SOC_Override_Worktag_Reference value
     * @return \StructType\Tenanted_Payroll_WorktagObjectType[]|null
     */
    public function getSOC_Override_Worktag_Reference()
    {
        return $this->SOC_Override_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSOC_Override_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSOC_Override_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSOC_Override_Worktag_ReferenceForArrayConstraintsFromSetSOC_Override_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salary_Over_the_Cap_Costing_Allocation_Detail_DataTypeSOC_Override_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$salary_Over_the_Cap_Costing_Allocation_Detail_DataTypeSOC_Override_Worktag_ReferenceItem instanceof \StructType\Tenanted_Payroll_WorktagObjectType) {
                $invalidValues[] = is_object($salary_Over_the_Cap_Costing_Allocation_Detail_DataTypeSOC_Override_Worktag_ReferenceItem) ? get_class($salary_Over_the_Cap_Costing_Allocation_Detail_DataTypeSOC_Override_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($salary_Over_the_Cap_Costing_Allocation_Detail_DataTypeSOC_Override_Worktag_ReferenceItem), var_export($salary_Over_the_Cap_Costing_Allocation_Detail_DataTypeSOC_Override_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SOC_Override_Worktag_Reference property can only contain items of type \StructType\Tenanted_Payroll_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SOC_Override_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Payroll_WorktagObjectType[] $sOC_Override_Worktag_Reference
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     */
    public function setSOC_Override_Worktag_Reference(array $sOC_Override_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($sOC_Override_Worktag_ReferenceArrayErrorMessage = self::validateSOC_Override_Worktag_ReferenceForArrayConstraintsFromSetSOC_Override_Worktag_Reference($sOC_Override_Worktag_Reference))) {
            throw new \InvalidArgumentException($sOC_Override_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->SOC_Override_Worktag_Reference = $sOC_Override_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to SOC_Override_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Payroll_WorktagObjectType $item
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     */
    public function addToSOC_Override_Worktag_Reference(\StructType\Tenanted_Payroll_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tenanted_Payroll_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The SOC_Override_Worktag_Reference property can only contain items of type \StructType\Tenanted_Payroll_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SOC_Override_Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get SOC_Distribution_Percent value
     * @return float|null
     */
    public function getSOC_Distribution_Percent()
    {
        return $this->SOC_Distribution_Percent;
    }
    /**
     * Set SOC_Distribution_Percent value
     * @param float $sOC_Distribution_Percent
     * @return \StructType\Salary_Over_the_Cap_Costing_Allocation_Detail_DataType
     */
    public function setSOC_Distribution_Percent($sOC_Distribution_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($sOC_Distribution_Percent) && !(is_float($sOC_Distribution_Percent) || is_numeric($sOC_Distribution_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sOC_Distribution_Percent, true), gettype($sOC_Distribution_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($sOC_Distribution_Percent) && mb_strlen(mb_substr($sOC_Distribution_Percent, false !== mb_strpos($sOC_Distribution_Percent, '.') ? mb_strpos($sOC_Distribution_Percent, '.') + 1 : mb_strlen($sOC_Distribution_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($sOC_Distribution_Percent, true), mb_strlen(mb_substr($sOC_Distribution_Percent, mb_strpos($sOC_Distribution_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sOC_Distribution_Percent) && $sOC_Distribution_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sOC_Distribution_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($sOC_Distribution_Percent) && mb_strlen(preg_replace('/(\D)/', '', $sOC_Distribution_Percent)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($sOC_Distribution_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $sOC_Distribution_Percent))), __LINE__);
        }
        $this->SOC_Distribution_Percent = $sOC_Distribution_Percent;
        return $this;
    }
}
