<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_One_Time_Payment_Sub_Business_ProcessType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Grant an employee a one-time payment such as a referral, spot bonus, or severance pay. Uses the Request One Time Payment business event through the web service.Can be skipped, processed automatically or processed manually.
 * @subpackage Structs
 */
class Request_One_Time_Payment_Sub_Business_ProcessType extends AbstractStructBase
{
    /**
     * The Business_Sub_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Parameters to indicate whether the subprocess should be completed automatically, initiated and left for manual completion, or skipped. If skip is selected, the subprocess must be tagged as optional.
     * - minOccurs: 0
     * @var \StructType\Business_Sub_Process_ParametersType
     */
    public $Business_Sub_Process_Parameters;
    /**
     * The Request_One_Time_Payment_Data
     * Meta information extracted from the WSDL
     * - documentation: Data Element that contains the one-time payment information for the terminate employee process.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\One_Time_Payment_DataType[]
     */
    public $Request_One_Time_Payment_Data;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the one-time payment for the employee is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reason for the one-time payment. Use format: General_Event_Subcategory_ID.
     * - minOccurs: 0
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Reason_Reference;
    /**
     * Constructor method for Request_One_Time_Payment_Sub_Business_ProcessType
     * @uses Request_One_Time_Payment_Sub_Business_ProcessType::setBusiness_Sub_Process_Parameters()
     * @uses Request_One_Time_Payment_Sub_Business_ProcessType::setRequest_One_Time_Payment_Data()
     * @uses Request_One_Time_Payment_Sub_Business_ProcessType::setEffective_Date()
     * @uses Request_One_Time_Payment_Sub_Business_ProcessType::setReason_Reference()
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @param \StructType\One_Time_Payment_DataType[] $request_One_Time_Payment_Data
     * @param string $effective_Date
     * @param \StructType\Event_Classification_SubcategoryObjectType $reason_Reference
     */
    public function __construct(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null, array $request_One_Time_Payment_Data = array(), $effective_Date = null, \StructType\Event_Classification_SubcategoryObjectType $reason_Reference = null)
    {
        $this
            ->setBusiness_Sub_Process_Parameters($business_Sub_Process_Parameters)
            ->setRequest_One_Time_Payment_Data($request_One_Time_Payment_Data)
            ->setEffective_Date($effective_Date)
            ->setReason_Reference($reason_Reference);
    }
    /**
     * Get Business_Sub_Process_Parameters value
     * @return \StructType\Business_Sub_Process_ParametersType|null
     */
    public function getBusiness_Sub_Process_Parameters()
    {
        return $this->Business_Sub_Process_Parameters;
    }
    /**
     * Set Business_Sub_Process_Parameters value
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @return \StructType\Request_One_Time_Payment_Sub_Business_ProcessType
     */
    public function setBusiness_Sub_Process_Parameters(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null)
    {
        $this->Business_Sub_Process_Parameters = $business_Sub_Process_Parameters;
        return $this;
    }
    /**
     * Get Request_One_Time_Payment_Data value
     * @return \StructType\One_Time_Payment_DataType[]|null
     */
    public function getRequest_One_Time_Payment_Data()
    {
        return $this->Request_One_Time_Payment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_One_Time_Payment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_One_Time_Payment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_One_Time_Payment_DataForArrayConstraintsFromSetRequest_One_Time_Payment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_One_Time_Payment_Sub_Business_ProcessTypeRequest_One_Time_Payment_DataItem) {
            // validation for constraint: itemType
            if (!$request_One_Time_Payment_Sub_Business_ProcessTypeRequest_One_Time_Payment_DataItem instanceof \StructType\One_Time_Payment_DataType) {
                $invalidValues[] = is_object($request_One_Time_Payment_Sub_Business_ProcessTypeRequest_One_Time_Payment_DataItem) ? get_class($request_One_Time_Payment_Sub_Business_ProcessTypeRequest_One_Time_Payment_DataItem) : sprintf('%s(%s)', gettype($request_One_Time_Payment_Sub_Business_ProcessTypeRequest_One_Time_Payment_DataItem), var_export($request_One_Time_Payment_Sub_Business_ProcessTypeRequest_One_Time_Payment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_One_Time_Payment_Data property can only contain items of type \StructType\One_Time_Payment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_One_Time_Payment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\One_Time_Payment_DataType[] $request_One_Time_Payment_Data
     * @return \StructType\Request_One_Time_Payment_Sub_Business_ProcessType
     */
    public function setRequest_One_Time_Payment_Data(array $request_One_Time_Payment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_One_Time_Payment_DataArrayErrorMessage = self::validateRequest_One_Time_Payment_DataForArrayConstraintsFromSetRequest_One_Time_Payment_Data($request_One_Time_Payment_Data))) {
            throw new \InvalidArgumentException($request_One_Time_Payment_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_One_Time_Payment_Data = $request_One_Time_Payment_Data;
        return $this;
    }
    /**
     * Add item to Request_One_Time_Payment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\One_Time_Payment_DataType $item
     * @return \StructType\Request_One_Time_Payment_Sub_Business_ProcessType
     */
    public function addToRequest_One_Time_Payment_Data(\StructType\One_Time_Payment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\One_Time_Payment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_One_Time_Payment_Data property can only contain items of type \StructType\One_Time_Payment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_One_Time_Payment_Data[] = $item;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Request_One_Time_Payment_Sub_Business_ProcessType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getReason_Reference()
    {
        return $this->Reason_Reference;
    }
    /**
     * Set Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $reason_Reference
     * @return \StructType\Request_One_Time_Payment_Sub_Business_ProcessType
     */
    public function setReason_Reference(\StructType\Event_Classification_SubcategoryObjectType $reason_Reference = null)
    {
        $this->Reason_Reference = $reason_Reference;
        return $this;
    }
}
