<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referral_Ownership_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about the current referral ownership details of a candidate.
 * @subpackage Structs
 */
class Referral_Ownership_Details_DataType extends AbstractStructBase
{
    /**
     * The Candidate_Owner_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for the worker who owns the candidate.
     * @var \StructType\WorkerObjectType
     */
    public $Candidate_Owner_Worker_Reference;
    /**
     * The Ownership_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The ownership start date for the referral ownership details of a candidate.
     * - maxOccurs: 1
     * @var string
     */
    public $Ownership_Start_Date;
    /**
     * The Ownership_End_Date
     * Meta information extracted from the WSDL
     * - documentation: The ownership end date for the referral ownership details of a candidate.
     * - maxOccurs: 1
     * @var string
     */
    public $Ownership_End_Date;
    /**
     * Constructor method for Referral_Ownership_Details_DataType
     * @uses Referral_Ownership_Details_DataType::setCandidate_Owner_Worker_Reference()
     * @uses Referral_Ownership_Details_DataType::setOwnership_Start_Date()
     * @uses Referral_Ownership_Details_DataType::setOwnership_End_Date()
     * @param \StructType\WorkerObjectType $candidate_Owner_Worker_Reference
     * @param string $ownership_Start_Date
     * @param string $ownership_End_Date
     */
    public function __construct(\StructType\WorkerObjectType $candidate_Owner_Worker_Reference = null, $ownership_Start_Date = null, $ownership_End_Date = null)
    {
        $this
            ->setCandidate_Owner_Worker_Reference($candidate_Owner_Worker_Reference)
            ->setOwnership_Start_Date($ownership_Start_Date)
            ->setOwnership_End_Date($ownership_End_Date);
    }
    /**
     * Get Candidate_Owner_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getCandidate_Owner_Worker_Reference()
    {
        return $this->Candidate_Owner_Worker_Reference;
    }
    /**
     * Set Candidate_Owner_Worker_Reference value
     * @param \StructType\WorkerObjectType $candidate_Owner_Worker_Reference
     * @return \StructType\Referral_Ownership_Details_DataType
     */
    public function setCandidate_Owner_Worker_Reference(\StructType\WorkerObjectType $candidate_Owner_Worker_Reference = null)
    {
        $this->Candidate_Owner_Worker_Reference = $candidate_Owner_Worker_Reference;
        return $this;
    }
    /**
     * Get Ownership_Start_Date value
     * @return string|null
     */
    public function getOwnership_Start_Date()
    {
        return $this->Ownership_Start_Date;
    }
    /**
     * Set Ownership_Start_Date value
     * @param string $ownership_Start_Date
     * @return \StructType\Referral_Ownership_Details_DataType
     */
    public function setOwnership_Start_Date($ownership_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($ownership_Start_Date) && !is_string($ownership_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownership_Start_Date, true), gettype($ownership_Start_Date)), __LINE__);
        }
        $this->Ownership_Start_Date = $ownership_Start_Date;
        return $this;
    }
    /**
     * Get Ownership_End_Date value
     * @return string|null
     */
    public function getOwnership_End_Date()
    {
        return $this->Ownership_End_Date;
    }
    /**
     * Set Ownership_End_Date value
     * @param string $ownership_End_Date
     * @return \StructType\Referral_Ownership_Details_DataType
     */
    public function setOwnership_End_Date($ownership_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($ownership_End_Date) && !is_string($ownership_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownership_End_Date, true), gettype($ownership_End_Date)), __LINE__);
        }
        $this->Ownership_End_Date = $ownership_End_Date;
        return $this;
    }
}
