<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Prospect_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Prospect Data: Level, Status, and Type
 * @subpackage Structs
 */
class Recruiting_Prospect_DataType extends AbstractStructBase
{
    /**
     * The Prospect
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the candidate is a prospect.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prospect;
    /**
     * The Confidential
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Prospect is confidential.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Confidential;
    /**
     * The Referral_Consent_Given
     * Meta information extracted from the WSDL
     * - documentation: Indicates if candidate has given their consent to being referred
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Referral_Consent_Given;
    /**
     * The Level_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Management Level
     * - minOccurs: 0
     * @var \StructType\Management_LevelObjectType
     */
    public $Level_Reference;
    /**
     * The Prospect_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Prospect Status
     * - minOccurs: 0
     * @var \StructType\Recruiting_Prospect_StatusObjectType
     */
    public $Prospect_Status_Reference;
    /**
     * The Prospect_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Prospect Type
     * - minOccurs: 0
     * @var \StructType\Recruiting_Prospect_TypeObjectType
     */
    public $Prospect_Type_Reference;
    /**
     * The Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: If candidate is referred, the source should be the referral source. | Reference to an applicant source.
     * - minOccurs: 0
     * @var \StructType\Applicant_SourceObjectType
     */
    public $Source_Reference;
    /**
     * The Referred_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a worker who referred the Candidate
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Referred_By_Worker_Reference;
    /**
     * The Referral_Job_Reference
     * Meta information extracted from the WSDL
     * - documentation: The job requisitions that the prospect was referred to.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType[]
     */
    public $Referral_Job_Reference;
    /**
     * The Referral_Job_Area_Reference
     * Meta information extracted from the WSDL
     * - documentation: The job areas that the prospect was referred to.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_FamilyObjectType[]
     */
    public $Referral_Job_Area_Reference;
    /**
     * The Referral_Relationship_Reference
     * Meta information extracted from the WSDL
     * - documentation: The relationship between the referring worker and the referral prospect.
     * - minOccurs: 0
     * @var \StructType\Referral_RelationshipObjectType
     */
    public $Referral_Relationship_Reference;
    /**
     * The Referral_Comment
     * Meta information extracted from the WSDL
     * - documentation: The comment provided by the referring worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referral_Comment;
    /**
     * The Added_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a worker who create the Job Application
     * - minOccurs: 0
     * @var \StructType\Process_maintained_RoleObjectType
     */
    public $Added_By_Worker_Reference;
    /**
     * The Prospect_Attachment_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Prospect_Attachments_DataType
     */
    public $Prospect_Attachment_Data;
    /**
     * The Resume_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Resume_DataType
     */
    public $Resume_Data;
    /**
     * Constructor method for Recruiting_Prospect_DataType
     * @uses Recruiting_Prospect_DataType::setProspect()
     * @uses Recruiting_Prospect_DataType::setConfidential()
     * @uses Recruiting_Prospect_DataType::setReferral_Consent_Given()
     * @uses Recruiting_Prospect_DataType::setLevel_Reference()
     * @uses Recruiting_Prospect_DataType::setProspect_Status_Reference()
     * @uses Recruiting_Prospect_DataType::setProspect_Type_Reference()
     * @uses Recruiting_Prospect_DataType::setSource_Reference()
     * @uses Recruiting_Prospect_DataType::setReferred_By_Worker_Reference()
     * @uses Recruiting_Prospect_DataType::setReferral_Job_Reference()
     * @uses Recruiting_Prospect_DataType::setReferral_Job_Area_Reference()
     * @uses Recruiting_Prospect_DataType::setReferral_Relationship_Reference()
     * @uses Recruiting_Prospect_DataType::setReferral_Comment()
     * @uses Recruiting_Prospect_DataType::setAdded_By_Worker_Reference()
     * @uses Recruiting_Prospect_DataType::setProspect_Attachment_Data()
     * @uses Recruiting_Prospect_DataType::setResume_Data()
     * @param bool $prospect
     * @param bool $confidential
     * @param bool $referral_Consent_Given
     * @param \StructType\Management_LevelObjectType $level_Reference
     * @param \StructType\Recruiting_Prospect_StatusObjectType $prospect_Status_Reference
     * @param \StructType\Recruiting_Prospect_TypeObjectType $prospect_Type_Reference
     * @param \StructType\Applicant_SourceObjectType $source_Reference
     * @param \StructType\WorkerObjectType $referred_By_Worker_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType[] $referral_Job_Reference
     * @param \StructType\Job_FamilyObjectType[] $referral_Job_Area_Reference
     * @param \StructType\Referral_RelationshipObjectType $referral_Relationship_Reference
     * @param string $referral_Comment
     * @param \StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference
     * @param \StructType\Prospect_Attachments_DataType $prospect_Attachment_Data
     * @param \StructType\Candidate_Resume_DataType $resume_Data
     */
    public function __construct($prospect = null, $confidential = null, $referral_Consent_Given = null, \StructType\Management_LevelObjectType $level_Reference = null, \StructType\Recruiting_Prospect_StatusObjectType $prospect_Status_Reference = null, \StructType\Recruiting_Prospect_TypeObjectType $prospect_Type_Reference = null, \StructType\Applicant_SourceObjectType $source_Reference = null, \StructType\WorkerObjectType $referred_By_Worker_Reference = null, array $referral_Job_Reference = array(), array $referral_Job_Area_Reference = array(), \StructType\Referral_RelationshipObjectType $referral_Relationship_Reference = null, $referral_Comment = null, \StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference = null, \StructType\Prospect_Attachments_DataType $prospect_Attachment_Data = null, \StructType\Candidate_Resume_DataType $resume_Data = null)
    {
        $this
            ->setProspect($prospect)
            ->setConfidential($confidential)
            ->setReferral_Consent_Given($referral_Consent_Given)
            ->setLevel_Reference($level_Reference)
            ->setProspect_Status_Reference($prospect_Status_Reference)
            ->setProspect_Type_Reference($prospect_Type_Reference)
            ->setSource_Reference($source_Reference)
            ->setReferred_By_Worker_Reference($referred_By_Worker_Reference)
            ->setReferral_Job_Reference($referral_Job_Reference)
            ->setReferral_Job_Area_Reference($referral_Job_Area_Reference)
            ->setReferral_Relationship_Reference($referral_Relationship_Reference)
            ->setReferral_Comment($referral_Comment)
            ->setAdded_By_Worker_Reference($added_By_Worker_Reference)
            ->setProspect_Attachment_Data($prospect_Attachment_Data)
            ->setResume_Data($resume_Data);
    }
    /**
     * Get Prospect value
     * @return bool|null
     */
    public function getProspect()
    {
        return $this->Prospect;
    }
    /**
     * Set Prospect value
     * @param bool $prospect
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setProspect($prospect = null)
    {
        // validation for constraint: boolean
        if (!is_null($prospect) && !is_bool($prospect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prospect, true), gettype($prospect)), __LINE__);
        }
        $this->Prospect = $prospect;
        return $this;
    }
    /**
     * Get Confidential value
     * @return bool|null
     */
    public function getConfidential()
    {
        return $this->Confidential;
    }
    /**
     * Set Confidential value
     * @param bool $confidential
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setConfidential($confidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($confidential) && !is_bool($confidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confidential, true), gettype($confidential)), __LINE__);
        }
        $this->Confidential = $confidential;
        return $this;
    }
    /**
     * Get Referral_Consent_Given value
     * @return bool|null
     */
    public function getReferral_Consent_Given()
    {
        return $this->Referral_Consent_Given;
    }
    /**
     * Set Referral_Consent_Given value
     * @param bool $referral_Consent_Given
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setReferral_Consent_Given($referral_Consent_Given = null)
    {
        // validation for constraint: boolean
        if (!is_null($referral_Consent_Given) && !is_bool($referral_Consent_Given)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($referral_Consent_Given, true), gettype($referral_Consent_Given)), __LINE__);
        }
        $this->Referral_Consent_Given = $referral_Consent_Given;
        return $this;
    }
    /**
     * Get Level_Reference value
     * @return \StructType\Management_LevelObjectType|null
     */
    public function getLevel_Reference()
    {
        return $this->Level_Reference;
    }
    /**
     * Set Level_Reference value
     * @param \StructType\Management_LevelObjectType $level_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setLevel_Reference(\StructType\Management_LevelObjectType $level_Reference = null)
    {
        $this->Level_Reference = $level_Reference;
        return $this;
    }
    /**
     * Get Prospect_Status_Reference value
     * @return \StructType\Recruiting_Prospect_StatusObjectType|null
     */
    public function getProspect_Status_Reference()
    {
        return $this->Prospect_Status_Reference;
    }
    /**
     * Set Prospect_Status_Reference value
     * @param \StructType\Recruiting_Prospect_StatusObjectType $prospect_Status_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setProspect_Status_Reference(\StructType\Recruiting_Prospect_StatusObjectType $prospect_Status_Reference = null)
    {
        $this->Prospect_Status_Reference = $prospect_Status_Reference;
        return $this;
    }
    /**
     * Get Prospect_Type_Reference value
     * @return \StructType\Recruiting_Prospect_TypeObjectType|null
     */
    public function getProspect_Type_Reference()
    {
        return $this->Prospect_Type_Reference;
    }
    /**
     * Set Prospect_Type_Reference value
     * @param \StructType\Recruiting_Prospect_TypeObjectType $prospect_Type_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setProspect_Type_Reference(\StructType\Recruiting_Prospect_TypeObjectType $prospect_Type_Reference = null)
    {
        $this->Prospect_Type_Reference = $prospect_Type_Reference;
        return $this;
    }
    /**
     * Get Source_Reference value
     * @return \StructType\Applicant_SourceObjectType|null
     */
    public function getSource_Reference()
    {
        return $this->Source_Reference;
    }
    /**
     * Set Source_Reference value
     * @param \StructType\Applicant_SourceObjectType $source_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setSource_Reference(\StructType\Applicant_SourceObjectType $source_Reference = null)
    {
        $this->Source_Reference = $source_Reference;
        return $this;
    }
    /**
     * Get Referred_By_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getReferred_By_Worker_Reference()
    {
        return $this->Referred_By_Worker_Reference;
    }
    /**
     * Set Referred_By_Worker_Reference value
     * @param \StructType\WorkerObjectType $referred_By_Worker_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setReferred_By_Worker_Reference(\StructType\WorkerObjectType $referred_By_Worker_Reference = null)
    {
        $this->Referred_By_Worker_Reference = $referred_By_Worker_Reference;
        return $this;
    }
    /**
     * Get Referral_Job_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType[]|null
     */
    public function getReferral_Job_Reference()
    {
        return $this->Referral_Job_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReferral_Job_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferral_Job_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferral_Job_ReferenceForArrayConstraintsFromSetReferral_Job_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Prospect_DataTypeReferral_Job_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Prospect_DataTypeReferral_Job_ReferenceItem instanceof \StructType\Job_Requisition_EnabledObjectType) {
                $invalidValues[] = is_object($recruiting_Prospect_DataTypeReferral_Job_ReferenceItem) ? get_class($recruiting_Prospect_DataTypeReferral_Job_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Prospect_DataTypeReferral_Job_ReferenceItem), var_export($recruiting_Prospect_DataTypeReferral_Job_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referral_Job_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referral_Job_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType[] $referral_Job_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setReferral_Job_Reference(array $referral_Job_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referral_Job_ReferenceArrayErrorMessage = self::validateReferral_Job_ReferenceForArrayConstraintsFromSetReferral_Job_Reference($referral_Job_Reference))) {
            throw new \InvalidArgumentException($referral_Job_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Referral_Job_Reference = $referral_Job_Reference;
        return $this;
    }
    /**
     * Add item to Referral_Job_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType $item
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function addToReferral_Job_Reference(\StructType\Job_Requisition_EnabledObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_EnabledObjectType) {
            throw new \InvalidArgumentException(sprintf('The Referral_Job_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referral_Job_Reference[] = $item;
        return $this;
    }
    /**
     * Get Referral_Job_Area_Reference value
     * @return \StructType\Job_FamilyObjectType[]|null
     */
    public function getReferral_Job_Area_Reference()
    {
        return $this->Referral_Job_Area_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReferral_Job_Area_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferral_Job_Area_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferral_Job_Area_ReferenceForArrayConstraintsFromSetReferral_Job_Area_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Prospect_DataTypeReferral_Job_Area_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Prospect_DataTypeReferral_Job_Area_ReferenceItem instanceof \StructType\Job_FamilyObjectType) {
                $invalidValues[] = is_object($recruiting_Prospect_DataTypeReferral_Job_Area_ReferenceItem) ? get_class($recruiting_Prospect_DataTypeReferral_Job_Area_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Prospect_DataTypeReferral_Job_Area_ReferenceItem), var_export($recruiting_Prospect_DataTypeReferral_Job_Area_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referral_Job_Area_Reference property can only contain items of type \StructType\Job_FamilyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referral_Job_Area_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_FamilyObjectType[] $referral_Job_Area_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setReferral_Job_Area_Reference(array $referral_Job_Area_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referral_Job_Area_ReferenceArrayErrorMessage = self::validateReferral_Job_Area_ReferenceForArrayConstraintsFromSetReferral_Job_Area_Reference($referral_Job_Area_Reference))) {
            throw new \InvalidArgumentException($referral_Job_Area_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Referral_Job_Area_Reference = $referral_Job_Area_Reference;
        return $this;
    }
    /**
     * Add item to Referral_Job_Area_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_FamilyObjectType $item
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function addToReferral_Job_Area_Reference(\StructType\Job_FamilyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_FamilyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Referral_Job_Area_Reference property can only contain items of type \StructType\Job_FamilyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referral_Job_Area_Reference[] = $item;
        return $this;
    }
    /**
     * Get Referral_Relationship_Reference value
     * @return \StructType\Referral_RelationshipObjectType|null
     */
    public function getReferral_Relationship_Reference()
    {
        return $this->Referral_Relationship_Reference;
    }
    /**
     * Set Referral_Relationship_Reference value
     * @param \StructType\Referral_RelationshipObjectType $referral_Relationship_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setReferral_Relationship_Reference(\StructType\Referral_RelationshipObjectType $referral_Relationship_Reference = null)
    {
        $this->Referral_Relationship_Reference = $referral_Relationship_Reference;
        return $this;
    }
    /**
     * Get Referral_Comment value
     * @return string|null
     */
    public function getReferral_Comment()
    {
        return $this->Referral_Comment;
    }
    /**
     * Set Referral_Comment value
     * @param string $referral_Comment
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setReferral_Comment($referral_Comment = null)
    {
        // validation for constraint: string
        if (!is_null($referral_Comment) && !is_string($referral_Comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referral_Comment, true), gettype($referral_Comment)), __LINE__);
        }
        $this->Referral_Comment = $referral_Comment;
        return $this;
    }
    /**
     * Get Added_By_Worker_Reference value
     * @return \StructType\Process_maintained_RoleObjectType|null
     */
    public function getAdded_By_Worker_Reference()
    {
        return $this->Added_By_Worker_Reference;
    }
    /**
     * Set Added_By_Worker_Reference value
     * @param \StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setAdded_By_Worker_Reference(\StructType\Process_maintained_RoleObjectType $added_By_Worker_Reference = null)
    {
        $this->Added_By_Worker_Reference = $added_By_Worker_Reference;
        return $this;
    }
    /**
     * Get Prospect_Attachment_Data value
     * @return \StructType\Prospect_Attachments_DataType|null
     */
    public function getProspect_Attachment_Data()
    {
        return $this->Prospect_Attachment_Data;
    }
    /**
     * Set Prospect_Attachment_Data value
     * @param \StructType\Prospect_Attachments_DataType $prospect_Attachment_Data
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setProspect_Attachment_Data(\StructType\Prospect_Attachments_DataType $prospect_Attachment_Data = null)
    {
        $this->Prospect_Attachment_Data = $prospect_Attachment_Data;
        return $this;
    }
    /**
     * Get Resume_Data value
     * @return \StructType\Candidate_Resume_DataType|null
     */
    public function getResume_Data()
    {
        return $this->Resume_Data;
    }
    /**
     * Set Resume_Data value
     * @param \StructType\Candidate_Resume_DataType $resume_Data
     * @return \StructType\Recruiting_Prospect_DataType
     */
    public function setResume_Data(\StructType\Candidate_Resume_DataType $resume_Data = null)
    {
        $this->Resume_Data = $resume_Data;
        return $this;
    }
}
