<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Recruiting Information.
 * @subpackage Structs
 */
class Recruiting_DataType extends AbstractStructBase
{
    /**
     * The Applicant_Entered_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the applicant was created.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Applicant_Entered_Date;
    /**
     * The Applicant_Comments
     * Meta information extracted from the WSDL
     * - documentation: Comments about the applicant.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Applicant_Comments;
    /**
     * The Eligible_For_Hire_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter Yes if the pre-hire is eligible for hire. Enter No if the pre-hire isn’t eligible for hire. If empty, Workday uses the existing hire eligibility status.
     * - minOccurs: 0
     * @var \StructType\Common_Yes_NoObjectType
     */
    public $Eligible_For_Hire_Reference;
    /**
     * The Eligible_for_Rehire_Comments
     * Meta information extracted from the WSDL
     * - documentation: Comment on the rehire eligibility status for the prehire.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Eligible_for_Rehire_Comments;
    /**
     * The Applicant_Has_Marked_as_No_Show_Reference
     * Meta information extracted from the WSDL
     * - documentation: This pre-hire was previously marked as a no show.
     * - minOccurs: 0
     * @var \StructType\Common_Boolean_EnumerationObjectType
     */
    public $Applicant_Has_Marked_as_No_Show_Reference;
    /**
     * The Applicant_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source of the applicant. Examples are : job site, college recruitment, advertisement.
     * - minOccurs: 0
     * @var \StructType\Applicant_SourceObjectType
     */
    public $Applicant_Source_Reference;
    /**
     * The Referred_by_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker referring the applicant.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Referred_by_Worker_Reference;
    /**
     * The Positions_Considered_for_Reference
     * Meta information extracted from the WSDL
     * - documentation: The positions that the applicant is considered for.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position_GroupObjectType[]
     */
    public $Positions_Considered_for_Reference;
    /**
     * Constructor method for Recruiting_DataType
     * @uses Recruiting_DataType::setApplicant_Entered_Date()
     * @uses Recruiting_DataType::setApplicant_Comments()
     * @uses Recruiting_DataType::setEligible_For_Hire_Reference()
     * @uses Recruiting_DataType::setEligible_for_Rehire_Comments()
     * @uses Recruiting_DataType::setApplicant_Has_Marked_as_No_Show_Reference()
     * @uses Recruiting_DataType::setApplicant_Source_Reference()
     * @uses Recruiting_DataType::setReferred_by_Worker_Reference()
     * @uses Recruiting_DataType::setPositions_Considered_for_Reference()
     * @param string $applicant_Entered_Date
     * @param string $applicant_Comments
     * @param \StructType\Common_Yes_NoObjectType $eligible_For_Hire_Reference
     * @param string $eligible_for_Rehire_Comments
     * @param \StructType\Common_Boolean_EnumerationObjectType $applicant_Has_Marked_as_No_Show_Reference
     * @param \StructType\Applicant_SourceObjectType $applicant_Source_Reference
     * @param \StructType\WorkerObjectType[] $referred_by_Worker_Reference
     * @param \StructType\Position_GroupObjectType[] $positions_Considered_for_Reference
     */
    public function __construct($applicant_Entered_Date = null, $applicant_Comments = null, \StructType\Common_Yes_NoObjectType $eligible_For_Hire_Reference = null, $eligible_for_Rehire_Comments = null, \StructType\Common_Boolean_EnumerationObjectType $applicant_Has_Marked_as_No_Show_Reference = null, \StructType\Applicant_SourceObjectType $applicant_Source_Reference = null, array $referred_by_Worker_Reference = array(), array $positions_Considered_for_Reference = array())
    {
        $this
            ->setApplicant_Entered_Date($applicant_Entered_Date)
            ->setApplicant_Comments($applicant_Comments)
            ->setEligible_For_Hire_Reference($eligible_For_Hire_Reference)
            ->setEligible_for_Rehire_Comments($eligible_for_Rehire_Comments)
            ->setApplicant_Has_Marked_as_No_Show_Reference($applicant_Has_Marked_as_No_Show_Reference)
            ->setApplicant_Source_Reference($applicant_Source_Reference)
            ->setReferred_by_Worker_Reference($referred_by_Worker_Reference)
            ->setPositions_Considered_for_Reference($positions_Considered_for_Reference);
    }
    /**
     * Get Applicant_Entered_Date value
     * @return string|null
     */
    public function getApplicant_Entered_Date()
    {
        return $this->Applicant_Entered_Date;
    }
    /**
     * Set Applicant_Entered_Date value
     * @param string $applicant_Entered_Date
     * @return \StructType\Recruiting_DataType
     */
    public function setApplicant_Entered_Date($applicant_Entered_Date = null)
    {
        // validation for constraint: string
        if (!is_null($applicant_Entered_Date) && !is_string($applicant_Entered_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicant_Entered_Date, true), gettype($applicant_Entered_Date)), __LINE__);
        }
        $this->Applicant_Entered_Date = $applicant_Entered_Date;
        return $this;
    }
    /**
     * Get Applicant_Comments value
     * @return string|null
     */
    public function getApplicant_Comments()
    {
        return $this->Applicant_Comments;
    }
    /**
     * Set Applicant_Comments value
     * @param string $applicant_Comments
     * @return \StructType\Recruiting_DataType
     */
    public function setApplicant_Comments($applicant_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($applicant_Comments) && !is_string($applicant_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicant_Comments, true), gettype($applicant_Comments)), __LINE__);
        }
        $this->Applicant_Comments = $applicant_Comments;
        return $this;
    }
    /**
     * Get Eligible_For_Hire_Reference value
     * @return \StructType\Common_Yes_NoObjectType|null
     */
    public function getEligible_For_Hire_Reference()
    {
        return $this->Eligible_For_Hire_Reference;
    }
    /**
     * Set Eligible_For_Hire_Reference value
     * @param \StructType\Common_Yes_NoObjectType $eligible_For_Hire_Reference
     * @return \StructType\Recruiting_DataType
     */
    public function setEligible_For_Hire_Reference(\StructType\Common_Yes_NoObjectType $eligible_For_Hire_Reference = null)
    {
        $this->Eligible_For_Hire_Reference = $eligible_For_Hire_Reference;
        return $this;
    }
    /**
     * Get Eligible_for_Rehire_Comments value
     * @return string|null
     */
    public function getEligible_for_Rehire_Comments()
    {
        return $this->Eligible_for_Rehire_Comments;
    }
    /**
     * Set Eligible_for_Rehire_Comments value
     * @param string $eligible_for_Rehire_Comments
     * @return \StructType\Recruiting_DataType
     */
    public function setEligible_for_Rehire_Comments($eligible_for_Rehire_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($eligible_for_Rehire_Comments) && !is_string($eligible_for_Rehire_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eligible_for_Rehire_Comments, true), gettype($eligible_for_Rehire_Comments)), __LINE__);
        }
        $this->Eligible_for_Rehire_Comments = $eligible_for_Rehire_Comments;
        return $this;
    }
    /**
     * Get Applicant_Has_Marked_as_No_Show_Reference value
     * @return \StructType\Common_Boolean_EnumerationObjectType|null
     */
    public function getApplicant_Has_Marked_as_No_Show_Reference()
    {
        return $this->Applicant_Has_Marked_as_No_Show_Reference;
    }
    /**
     * Set Applicant_Has_Marked_as_No_Show_Reference value
     * @param \StructType\Common_Boolean_EnumerationObjectType $applicant_Has_Marked_as_No_Show_Reference
     * @return \StructType\Recruiting_DataType
     */
    public function setApplicant_Has_Marked_as_No_Show_Reference(\StructType\Common_Boolean_EnumerationObjectType $applicant_Has_Marked_as_No_Show_Reference = null)
    {
        $this->Applicant_Has_Marked_as_No_Show_Reference = $applicant_Has_Marked_as_No_Show_Reference;
        return $this;
    }
    /**
     * Get Applicant_Source_Reference value
     * @return \StructType\Applicant_SourceObjectType|null
     */
    public function getApplicant_Source_Reference()
    {
        return $this->Applicant_Source_Reference;
    }
    /**
     * Set Applicant_Source_Reference value
     * @param \StructType\Applicant_SourceObjectType $applicant_Source_Reference
     * @return \StructType\Recruiting_DataType
     */
    public function setApplicant_Source_Reference(\StructType\Applicant_SourceObjectType $applicant_Source_Reference = null)
    {
        $this->Applicant_Source_Reference = $applicant_Source_Reference;
        return $this;
    }
    /**
     * Get Referred_by_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getReferred_by_Worker_Reference()
    {
        return $this->Referred_by_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReferred_by_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferred_by_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferred_by_Worker_ReferenceForArrayConstraintsFromSetReferred_by_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_DataTypeReferred_by_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_DataTypeReferred_by_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($recruiting_DataTypeReferred_by_Worker_ReferenceItem) ? get_class($recruiting_DataTypeReferred_by_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_DataTypeReferred_by_Worker_ReferenceItem), var_export($recruiting_DataTypeReferred_by_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referred_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referred_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $referred_by_Worker_Reference
     * @return \StructType\Recruiting_DataType
     */
    public function setReferred_by_Worker_Reference(array $referred_by_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referred_by_Worker_ReferenceArrayErrorMessage = self::validateReferred_by_Worker_ReferenceForArrayConstraintsFromSetReferred_by_Worker_Reference($referred_by_Worker_Reference))) {
            throw new \InvalidArgumentException($referred_by_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Referred_by_Worker_Reference = $referred_by_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Referred_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Recruiting_DataType
     */
    public function addToReferred_by_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Referred_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referred_by_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Positions_Considered_for_Reference value
     * @return \StructType\Position_GroupObjectType[]|null
     */
    public function getPositions_Considered_for_Reference()
    {
        return $this->Positions_Considered_for_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPositions_Considered_for_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPositions_Considered_for_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositions_Considered_for_ReferenceForArrayConstraintsFromSetPositions_Considered_for_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_DataTypePositions_Considered_for_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_DataTypePositions_Considered_for_ReferenceItem instanceof \StructType\Position_GroupObjectType) {
                $invalidValues[] = is_object($recruiting_DataTypePositions_Considered_for_ReferenceItem) ? get_class($recruiting_DataTypePositions_Considered_for_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_DataTypePositions_Considered_for_ReferenceItem), var_export($recruiting_DataTypePositions_Considered_for_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Positions_Considered_for_Reference property can only contain items of type \StructType\Position_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Positions_Considered_for_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_GroupObjectType[] $positions_Considered_for_Reference
     * @return \StructType\Recruiting_DataType
     */
    public function setPositions_Considered_for_Reference(array $positions_Considered_for_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($positions_Considered_for_ReferenceArrayErrorMessage = self::validatePositions_Considered_for_ReferenceForArrayConstraintsFromSetPositions_Considered_for_Reference($positions_Considered_for_Reference))) {
            throw new \InvalidArgumentException($positions_Considered_for_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Positions_Considered_for_Reference = $positions_Considered_for_Reference;
        return $this;
    }
    /**
     * Add item to Positions_Considered_for_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_GroupObjectType $item
     * @return \StructType\Recruiting_DataType
     */
    public function addToPositions_Considered_for_Reference(\StructType\Position_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Positions_Considered_for_Reference property can only contain items of type \StructType\Position_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Positions_Considered_for_Reference[] = $item;
        return $this;
    }
}
