<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Assessment_CategoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Recruiting Assessment Category Response Container
 * @subpackage Structs
 */
class Recruiting_Assessment_CategoryType extends AbstractStructBase
{
    /**
     * The Recruiting_Assessment_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Assessment Category Refernce
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_CategoryObjectType
     */
    public $Recruiting_Assessment_Category_Reference;
    /**
     * The Recruiting_Assessment_Category_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_Category_DataType[]
     */
    public $Recruiting_Assessment_Category_Data;
    /**
     * Constructor method for Recruiting_Assessment_CategoryType
     * @uses Recruiting_Assessment_CategoryType::setRecruiting_Assessment_Category_Reference()
     * @uses Recruiting_Assessment_CategoryType::setRecruiting_Assessment_Category_Data()
     * @param \StructType\Recruiting_Assessment_CategoryObjectType $recruiting_Assessment_Category_Reference
     * @param \StructType\Recruiting_Assessment_Category_DataType[] $recruiting_Assessment_Category_Data
     */
    public function __construct(\StructType\Recruiting_Assessment_CategoryObjectType $recruiting_Assessment_Category_Reference = null, array $recruiting_Assessment_Category_Data = array())
    {
        $this
            ->setRecruiting_Assessment_Category_Reference($recruiting_Assessment_Category_Reference)
            ->setRecruiting_Assessment_Category_Data($recruiting_Assessment_Category_Data);
    }
    /**
     * Get Recruiting_Assessment_Category_Reference value
     * @return \StructType\Recruiting_Assessment_CategoryObjectType|null
     */
    public function getRecruiting_Assessment_Category_Reference()
    {
        return $this->Recruiting_Assessment_Category_Reference;
    }
    /**
     * Set Recruiting_Assessment_Category_Reference value
     * @param \StructType\Recruiting_Assessment_CategoryObjectType $recruiting_Assessment_Category_Reference
     * @return \StructType\Recruiting_Assessment_CategoryType
     */
    public function setRecruiting_Assessment_Category_Reference(\StructType\Recruiting_Assessment_CategoryObjectType $recruiting_Assessment_Category_Reference = null)
    {
        $this->Recruiting_Assessment_Category_Reference = $recruiting_Assessment_Category_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Assessment_Category_Data value
     * @return \StructType\Recruiting_Assessment_Category_DataType[]|null
     */
    public function getRecruiting_Assessment_Category_Data()
    {
        return $this->Recruiting_Assessment_Category_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Assessment_Category_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Assessment_Category_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Assessment_Category_DataForArrayConstraintsFromSetRecruiting_Assessment_Category_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Assessment_CategoryTypeRecruiting_Assessment_Category_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Assessment_CategoryTypeRecruiting_Assessment_Category_DataItem instanceof \StructType\Recruiting_Assessment_Category_DataType) {
                $invalidValues[] = is_object($recruiting_Assessment_CategoryTypeRecruiting_Assessment_Category_DataItem) ? get_class($recruiting_Assessment_CategoryTypeRecruiting_Assessment_Category_DataItem) : sprintf('%s(%s)', gettype($recruiting_Assessment_CategoryTypeRecruiting_Assessment_Category_DataItem), var_export($recruiting_Assessment_CategoryTypeRecruiting_Assessment_Category_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Assessment_Category_Data property can only contain items of type \StructType\Recruiting_Assessment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Assessment_Category_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_Category_DataType[] $recruiting_Assessment_Category_Data
     * @return \StructType\Recruiting_Assessment_CategoryType
     */
    public function setRecruiting_Assessment_Category_Data(array $recruiting_Assessment_Category_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Assessment_Category_DataArrayErrorMessage = self::validateRecruiting_Assessment_Category_DataForArrayConstraintsFromSetRecruiting_Assessment_Category_Data($recruiting_Assessment_Category_Data))) {
            throw new \InvalidArgumentException($recruiting_Assessment_Category_DataArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Assessment_Category_Data = $recruiting_Assessment_Category_Data;
        return $this;
    }
    /**
     * Add item to Recruiting_Assessment_Category_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Assessment_Category_DataType $item
     * @return \StructType\Recruiting_Assessment_CategoryType
     */
    public function addToRecruiting_Assessment_Category_Data(\StructType\Recruiting_Assessment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Assessment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Assessment_Category_Data property can only contain items of type \StructType\Recruiting_Assessment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Assessment_Category_Data[] = $item;
        return $this;
    }
}
