<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_Additional_Data_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Recruiting Agency Additional Data
 * @subpackage Structs
 */
class Recruiting_Agency_Additional_Data_Response_DataType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_Custom_Object_Data
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency Additional Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_Additional_DataType[]
     */
    public $Recruiting_Agency_Custom_Object_Data;
    /**
     * Constructor method for Recruiting_Agency_Additional_Data_Response_DataType
     * @uses Recruiting_Agency_Additional_Data_Response_DataType::setRecruiting_Agency_Custom_Object_Data()
     * @param \StructType\Recruiting_Agency_Additional_DataType[] $recruiting_Agency_Custom_Object_Data
     */
    public function __construct(array $recruiting_Agency_Custom_Object_Data = array())
    {
        $this
            ->setRecruiting_Agency_Custom_Object_Data($recruiting_Agency_Custom_Object_Data);
    }
    /**
     * Get Recruiting_Agency_Custom_Object_Data value
     * @return \StructType\Recruiting_Agency_Additional_DataType[]|null
     */
    public function getRecruiting_Agency_Custom_Object_Data()
    {
        return $this->Recruiting_Agency_Custom_Object_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Agency_Custom_Object_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Agency_Custom_Object_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Agency_Custom_Object_DataForArrayConstraintsFromSetRecruiting_Agency_Custom_Object_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_Additional_Data_Response_DataTypeRecruiting_Agency_Custom_Object_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_Additional_Data_Response_DataTypeRecruiting_Agency_Custom_Object_DataItem instanceof \StructType\Recruiting_Agency_Additional_DataType) {
                $invalidValues[] = is_object($recruiting_Agency_Additional_Data_Response_DataTypeRecruiting_Agency_Custom_Object_DataItem) ? get_class($recruiting_Agency_Additional_Data_Response_DataTypeRecruiting_Agency_Custom_Object_DataItem) : sprintf('%s(%s)', gettype($recruiting_Agency_Additional_Data_Response_DataTypeRecruiting_Agency_Custom_Object_DataItem), var_export($recruiting_Agency_Additional_Data_Response_DataTypeRecruiting_Agency_Custom_Object_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Agency_Custom_Object_Data property can only contain items of type \StructType\Recruiting_Agency_Additional_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Agency_Custom_Object_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_Additional_DataType[] $recruiting_Agency_Custom_Object_Data
     * @return \StructType\Recruiting_Agency_Additional_Data_Response_DataType
     */
    public function setRecruiting_Agency_Custom_Object_Data(array $recruiting_Agency_Custom_Object_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Agency_Custom_Object_DataArrayErrorMessage = self::validateRecruiting_Agency_Custom_Object_DataForArrayConstraintsFromSetRecruiting_Agency_Custom_Object_Data($recruiting_Agency_Custom_Object_Data))) {
            throw new \InvalidArgumentException($recruiting_Agency_Custom_Object_DataArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Agency_Custom_Object_Data = $recruiting_Agency_Custom_Object_Data;
        return $this;
    }
    /**
     * Add item to Recruiting_Agency_Custom_Object_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_Additional_DataType $item
     * @return \StructType\Recruiting_Agency_Additional_Data_Response_DataType
     */
    public function addToRecruiting_Agency_Custom_Object_Data(\StructType\Recruiting_Agency_Additional_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_Additional_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Agency_Custom_Object_Data property can only contain items of type \StructType\Recruiting_Agency_Additional_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Agency_Custom_Object_Data[] = $item;
        return $this;
    }
}
