<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Qualifications_from_Position_Restrictions_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the position's and it's job profile's qualification information which includes the following: Competency, Certification, Education, Language, Responsibility, Training, and Work Experience
 * @subpackage Structs
 */
class Qualifications_from_Position_Restrictions_DataType extends AbstractStructBase
{
    /**
     * The Competency_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Competency_Profile_for_JobType[]
     */
    public $Competency_Data;
    /**
     * The Certification_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Certification_Profile_for_JobType[]
     */
    public $Certification_Data;
    /**
     * The Education_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Education_Profile_for_JobType[]
     */
    public $Education_Data;
    /**
     * The Language_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Language_Profile_for_JobType[]
     */
    public $Language_Data;
    /**
     * The Responsibility_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Responsibility_Profile_for_JobType[]
     */
    public $Responsibility_Data;
    /**
     * The Training_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Training_Profile_for_JobType[]
     */
    public $Training_Data;
    /**
     * The Work_Experience_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Work_Experience_for_JobType[]
     */
    public $Work_Experience_Data;
    /**
     * The Skill_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Skill_Profile_for_JobType[]
     */
    public $Skill_Data;
    /**
     * Constructor method for Qualifications_from_Position_Restrictions_DataType
     * @uses Qualifications_from_Position_Restrictions_DataType::setCompetency_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setCertification_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setEducation_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setLanguage_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setResponsibility_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setTraining_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setWork_Experience_Data()
     * @uses Qualifications_from_Position_Restrictions_DataType::setSkill_Data()
     * @param \StructType\Competency_Profile_for_JobType[] $competency_Data
     * @param \StructType\Certification_Profile_for_JobType[] $certification_Data
     * @param \StructType\Education_Profile_for_JobType[] $education_Data
     * @param \StructType\Language_Profile_for_JobType[] $language_Data
     * @param \StructType\Responsibility_Profile_for_JobType[] $responsibility_Data
     * @param \StructType\Training_Profile_for_JobType[] $training_Data
     * @param \StructType\Work_Experience_for_JobType[] $work_Experience_Data
     * @param \StructType\Skill_Profile_for_JobType[] $skill_Data
     */
    public function __construct(array $competency_Data = array(), array $certification_Data = array(), array $education_Data = array(), array $language_Data = array(), array $responsibility_Data = array(), array $training_Data = array(), array $work_Experience_Data = array(), array $skill_Data = array())
    {
        $this
            ->setCompetency_Data($competency_Data)
            ->setCertification_Data($certification_Data)
            ->setEducation_Data($education_Data)
            ->setLanguage_Data($language_Data)
            ->setResponsibility_Data($responsibility_Data)
            ->setTraining_Data($training_Data)
            ->setWork_Experience_Data($work_Experience_Data)
            ->setSkill_Data($skill_Data);
    }
    /**
     * Get Competency_Data value
     * @return \StructType\Competency_Profile_for_JobType[]|null
     */
    public function getCompetency_Data()
    {
        return $this->Competency_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCompetency_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompetency_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompetency_DataForArrayConstraintsFromSetCompetency_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeCompetency_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeCompetency_DataItem instanceof \StructType\Competency_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeCompetency_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeCompetency_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeCompetency_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeCompetency_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Competency_Data property can only contain items of type \StructType\Competency_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Competency_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Competency_Profile_for_JobType[] $competency_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setCompetency_Data(array $competency_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($competency_DataArrayErrorMessage = self::validateCompetency_DataForArrayConstraintsFromSetCompetency_Data($competency_Data))) {
            throw new \InvalidArgumentException($competency_DataArrayErrorMessage, __LINE__);
        }
        $this->Competency_Data = $competency_Data;
        return $this;
    }
    /**
     * Add item to Competency_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Competency_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToCompetency_Data(\StructType\Competency_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Competency_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Competency_Data property can only contain items of type \StructType\Competency_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Competency_Data[] = $item;
        return $this;
    }
    /**
     * Get Certification_Data value
     * @return \StructType\Certification_Profile_for_JobType[]|null
     */
    public function getCertification_Data()
    {
        return $this->Certification_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCertification_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertification_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertification_DataForArrayConstraintsFromSetCertification_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeCertification_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeCertification_DataItem instanceof \StructType\Certification_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeCertification_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeCertification_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeCertification_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeCertification_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Certification_Data property can only contain items of type \StructType\Certification_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Certification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Certification_Profile_for_JobType[] $certification_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setCertification_Data(array $certification_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($certification_DataArrayErrorMessage = self::validateCertification_DataForArrayConstraintsFromSetCertification_Data($certification_Data))) {
            throw new \InvalidArgumentException($certification_DataArrayErrorMessage, __LINE__);
        }
        $this->Certification_Data = $certification_Data;
        return $this;
    }
    /**
     * Add item to Certification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Certification_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToCertification_Data(\StructType\Certification_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Certification_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Certification_Data property can only contain items of type \StructType\Certification_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Certification_Data[] = $item;
        return $this;
    }
    /**
     * Get Education_Data value
     * @return \StructType\Education_Profile_for_JobType[]|null
     */
    public function getEducation_Data()
    {
        return $this->Education_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setEducation_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEducation_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEducation_DataForArrayConstraintsFromSetEducation_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeEducation_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeEducation_DataItem instanceof \StructType\Education_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeEducation_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeEducation_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeEducation_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeEducation_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Education_Data property can only contain items of type \StructType\Education_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Education_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Education_Profile_for_JobType[] $education_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setEducation_Data(array $education_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($education_DataArrayErrorMessage = self::validateEducation_DataForArrayConstraintsFromSetEducation_Data($education_Data))) {
            throw new \InvalidArgumentException($education_DataArrayErrorMessage, __LINE__);
        }
        $this->Education_Data = $education_Data;
        return $this;
    }
    /**
     * Add item to Education_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Education_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToEducation_Data(\StructType\Education_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Education_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Education_Data property can only contain items of type \StructType\Education_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Education_Data[] = $item;
        return $this;
    }
    /**
     * Get Language_Data value
     * @return \StructType\Language_Profile_for_JobType[]|null
     */
    public function getLanguage_Data()
    {
        return $this->Language_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguage_DataForArrayConstraintsFromSetLanguage_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeLanguage_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeLanguage_DataItem instanceof \StructType\Language_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeLanguage_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeLanguage_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeLanguage_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeLanguage_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language_Data property can only contain items of type \StructType\Language_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_Profile_for_JobType[] $language_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setLanguage_Data(array $language_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($language_DataArrayErrorMessage = self::validateLanguage_DataForArrayConstraintsFromSetLanguage_Data($language_Data))) {
            throw new \InvalidArgumentException($language_DataArrayErrorMessage, __LINE__);
        }
        $this->Language_Data = $language_Data;
        return $this;
    }
    /**
     * Add item to Language_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToLanguage_Data(\StructType\Language_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Language_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Language_Data property can only contain items of type \StructType\Language_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language_Data[] = $item;
        return $this;
    }
    /**
     * Get Responsibility_Data value
     * @return \StructType\Responsibility_Profile_for_JobType[]|null
     */
    public function getResponsibility_Data()
    {
        return $this->Responsibility_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResponsibility_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponsibility_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResponsibility_DataForArrayConstraintsFromSetResponsibility_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeResponsibility_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeResponsibility_DataItem instanceof \StructType\Responsibility_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeResponsibility_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeResponsibility_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeResponsibility_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeResponsibility_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Responsibility_Data property can only contain items of type \StructType\Responsibility_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Responsibility_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Responsibility_Profile_for_JobType[] $responsibility_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setResponsibility_Data(array $responsibility_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($responsibility_DataArrayErrorMessage = self::validateResponsibility_DataForArrayConstraintsFromSetResponsibility_Data($responsibility_Data))) {
            throw new \InvalidArgumentException($responsibility_DataArrayErrorMessage, __LINE__);
        }
        $this->Responsibility_Data = $responsibility_Data;
        return $this;
    }
    /**
     * Add item to Responsibility_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Responsibility_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToResponsibility_Data(\StructType\Responsibility_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Responsibility_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Responsibility_Data property can only contain items of type \StructType\Responsibility_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Responsibility_Data[] = $item;
        return $this;
    }
    /**
     * Get Training_Data value
     * @return \StructType\Training_Profile_for_JobType[]|null
     */
    public function getTraining_Data()
    {
        return $this->Training_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTraining_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTraining_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTraining_DataForArrayConstraintsFromSetTraining_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeTraining_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeTraining_DataItem instanceof \StructType\Training_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeTraining_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeTraining_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeTraining_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeTraining_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Training_Data property can only contain items of type \StructType\Training_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Training_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Training_Profile_for_JobType[] $training_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setTraining_Data(array $training_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($training_DataArrayErrorMessage = self::validateTraining_DataForArrayConstraintsFromSetTraining_Data($training_Data))) {
            throw new \InvalidArgumentException($training_DataArrayErrorMessage, __LINE__);
        }
        $this->Training_Data = $training_Data;
        return $this;
    }
    /**
     * Add item to Training_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Training_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToTraining_Data(\StructType\Training_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Training_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Training_Data property can only contain items of type \StructType\Training_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Training_Data[] = $item;
        return $this;
    }
    /**
     * Get Work_Experience_Data value
     * @return \StructType\Work_Experience_for_JobType[]|null
     */
    public function getWork_Experience_Data()
    {
        return $this->Work_Experience_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWork_Experience_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWork_Experience_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWork_Experience_DataForArrayConstraintsFromSetWork_Experience_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeWork_Experience_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeWork_Experience_DataItem instanceof \StructType\Work_Experience_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeWork_Experience_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeWork_Experience_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeWork_Experience_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeWork_Experience_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Work_Experience_Data property can only contain items of type \StructType\Work_Experience_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Work_Experience_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Work_Experience_for_JobType[] $work_Experience_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setWork_Experience_Data(array $work_Experience_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($work_Experience_DataArrayErrorMessage = self::validateWork_Experience_DataForArrayConstraintsFromSetWork_Experience_Data($work_Experience_Data))) {
            throw new \InvalidArgumentException($work_Experience_DataArrayErrorMessage, __LINE__);
        }
        $this->Work_Experience_Data = $work_Experience_Data;
        return $this;
    }
    /**
     * Add item to Work_Experience_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Work_Experience_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToWork_Experience_Data(\StructType\Work_Experience_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Work_Experience_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Work_Experience_Data property can only contain items of type \StructType\Work_Experience_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Work_Experience_Data[] = $item;
        return $this;
    }
    /**
     * Get Skill_Data value
     * @return \StructType\Skill_Profile_for_JobType[]|null
     */
    public function getSkill_Data()
    {
        return $this->Skill_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSkill_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkill_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkill_DataForArrayConstraintsFromSetSkill_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualifications_from_Position_Restrictions_DataTypeSkill_DataItem) {
            // validation for constraint: itemType
            if (!$qualifications_from_Position_Restrictions_DataTypeSkill_DataItem instanceof \StructType\Skill_Profile_for_JobType) {
                $invalidValues[] = is_object($qualifications_from_Position_Restrictions_DataTypeSkill_DataItem) ? get_class($qualifications_from_Position_Restrictions_DataTypeSkill_DataItem) : sprintf('%s(%s)', gettype($qualifications_from_Position_Restrictions_DataTypeSkill_DataItem), var_export($qualifications_from_Position_Restrictions_DataTypeSkill_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Skill_Data property can only contain items of type \StructType\Skill_Profile_for_JobType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Skill_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Skill_Profile_for_JobType[] $skill_Data
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function setSkill_Data(array $skill_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($skill_DataArrayErrorMessage = self::validateSkill_DataForArrayConstraintsFromSetSkill_Data($skill_Data))) {
            throw new \InvalidArgumentException($skill_DataArrayErrorMessage, __LINE__);
        }
        $this->Skill_Data = $skill_Data;
        return $this;
    }
    /**
     * Add item to Skill_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Skill_Profile_for_JobType $item
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public function addToSkill_Data(\StructType\Skill_Profile_for_JobType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Skill_Profile_for_JobType) {
            throw new \InvalidArgumentException(sprintf('The Skill_Data property can only contain items of type \StructType\Skill_Profile_for_JobType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Skill_Data[] = $item;
        return $this;
    }
}
