<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Veteran_Status_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the request data to add or update a Veteran Status.
 * @subpackage Structs
 */
class Put_Veteran_Status_RequestType extends AbstractStructBase
{
    /**
     * The Veteran_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Veteran Status.
     * - minOccurs: 0
     * @var \StructType\Veteran_StatusObjectType
     */
    public $Veteran_Status_Reference;
    /**
     * The Veteran_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains ID, Order, Veteran Status Name, Description, Inactive, and Global Setup Data Mapping.
     * - minOccurs: 0
     * @var \StructType\Veteran_Status_DataType
     */
    public $Veteran_Status_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Reference ID must be provided to allow delete. | In-use Veteran Statuses cannot be deleted. | Delete Flag
     * @var bool
     */
    public $Delete;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Veteran_Status_RequestType
     * @uses Put_Veteran_Status_RequestType::setVeteran_Status_Reference()
     * @uses Put_Veteran_Status_RequestType::setVeteran_Status_Data()
     * @uses Put_Veteran_Status_RequestType::setAdd_Only()
     * @uses Put_Veteran_Status_RequestType::setDelete()
     * @uses Put_Veteran_Status_RequestType::setVersion()
     * @param \StructType\Veteran_StatusObjectType $veteran_Status_Reference
     * @param \StructType\Veteran_Status_DataType $veteran_Status_Data
     * @param bool $add_Only
     * @param bool $delete
     * @param string $version
     */
    public function __construct(\StructType\Veteran_StatusObjectType $veteran_Status_Reference = null, \StructType\Veteran_Status_DataType $veteran_Status_Data = null, $add_Only = null, $delete = null, $version = null)
    {
        $this
            ->setVeteran_Status_Reference($veteran_Status_Reference)
            ->setVeteran_Status_Data($veteran_Status_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete)
            ->setVersion($version);
    }
    /**
     * Get Veteran_Status_Reference value
     * @return \StructType\Veteran_StatusObjectType|null
     */
    public function getVeteran_Status_Reference()
    {
        return $this->Veteran_Status_Reference;
    }
    /**
     * Set Veteran_Status_Reference value
     * @param \StructType\Veteran_StatusObjectType $veteran_Status_Reference
     * @return \StructType\Put_Veteran_Status_RequestType
     */
    public function setVeteran_Status_Reference(\StructType\Veteran_StatusObjectType $veteran_Status_Reference = null)
    {
        $this->Veteran_Status_Reference = $veteran_Status_Reference;
        return $this;
    }
    /**
     * Get Veteran_Status_Data value
     * @return \StructType\Veteran_Status_DataType|null
     */
    public function getVeteran_Status_Data()
    {
        return $this->Veteran_Status_Data;
    }
    /**
     * Set Veteran_Status_Data value
     * @param \StructType\Veteran_Status_DataType $veteran_Status_Data
     * @return \StructType\Put_Veteran_Status_RequestType
     */
    public function setVeteran_Status_Data(\StructType\Veteran_Status_DataType $veteran_Status_Data = null)
    {
        $this->Veteran_Status_Data = $veteran_Status_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Veteran_Status_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Put_Veteran_Status_RequestType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Veteran_Status_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
