<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Undo_Move_from_Hire_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: A request to undo the move from a staffing process back to the originating job application process.
 * @subpackage Structs
 */
class Put_Undo_Move_from_Hire_RequestType extends AbstractStructBase
{
    /**
     * The Job_Application_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application event.
     * - choice: Job_Application_Event_Reference | Staffing_Event_Reference | Job_Application_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Job_Application_Event_Reference;
    /**
     * The Staffing_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the staffing event for which you want to perform the undo move.
     * - choice: Job_Application_Event_Reference | Staffing_Event_Reference | Job_Application_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Staffing_Event_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the job application for which you want to perform the undo move.
     * - choice: Job_Application_Event_Reference | Staffing_Event_Reference | Job_Application_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Event_Classification_Subcategory_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reason for the undo move.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Event_Classification_Subcategory_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Free form comment regarding the business process.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Undo_Move_from_Hire_RequestType
     * @uses Put_Undo_Move_from_Hire_RequestType::setJob_Application_Event_Reference()
     * @uses Put_Undo_Move_from_Hire_RequestType::setStaffing_Event_Reference()
     * @uses Put_Undo_Move_from_Hire_RequestType::setJob_Application_Reference()
     * @uses Put_Undo_Move_from_Hire_RequestType::setEvent_Classification_Subcategory_Reference()
     * @uses Put_Undo_Move_from_Hire_RequestType::setComment()
     * @uses Put_Undo_Move_from_Hire_RequestType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @param \StructType\Unique_IdentifierObjectType $staffing_Event_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $event_Classification_Subcategory_Reference
     * @param string $comment
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null, \StructType\Unique_IdentifierObjectType $staffing_Event_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $event_Classification_Subcategory_Reference = null, $comment = null, $version = null)
    {
        $this
            ->setJob_Application_Event_Reference($job_Application_Event_Reference)
            ->setStaffing_Event_Reference($staffing_Event_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setEvent_Classification_Subcategory_Reference($event_Classification_Subcategory_Reference)
            ->setComment($comment)
            ->setVersion($version);
    }
    /**
     * Get Job_Application_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getJob_Application_Event_Reference()
    {
        return isset($this->Job_Application_Event_Reference) ? $this->Job_Application_Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Event_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Event_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_Event_ReferenceForChoiceConstraintsFromSetJob_Application_Event_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Staffing_Event_Reference',
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_RequestType
     */
    public function setJob_Application_Event_Reference(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Event_Reference, Staffing_Event_Reference, Job_Application_Reference)
        if ('' !== ($job_Application_Event_ReferenceChoiceErrorMessage = self::validateJob_Application_Event_ReferenceForChoiceConstraintsFromSetJob_Application_Event_Reference($job_Application_Event_Reference))) {
            throw new \InvalidArgumentException($job_Application_Event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Event_Reference) || (is_array($job_Application_Event_Reference) && empty($job_Application_Event_Reference))) {
            unset($this->Job_Application_Event_Reference);
        } else {
            $this->Job_Application_Event_Reference = $job_Application_Event_Reference;
        }
        return $this;
    }
    /**
     * Get Staffing_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getStaffing_Event_Reference()
    {
        return isset($this->Staffing_Event_Reference) ? $this->Staffing_Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStaffing_Event_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStaffing_Event_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStaffing_Event_ReferenceForChoiceConstraintsFromSetStaffing_Event_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Event_Reference',
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Staffing_Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Staffing_Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Staffing_Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $staffing_Event_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_RequestType
     */
    public function setStaffing_Event_Reference(\StructType\Unique_IdentifierObjectType $staffing_Event_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Event_Reference, Staffing_Event_Reference, Job_Application_Reference)
        if ('' !== ($staffing_Event_ReferenceChoiceErrorMessage = self::validateStaffing_Event_ReferenceForChoiceConstraintsFromSetStaffing_Event_Reference($staffing_Event_Reference))) {
            throw new \InvalidArgumentException($staffing_Event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($staffing_Event_Reference) || (is_array($staffing_Event_Reference) && empty($staffing_Event_Reference))) {
            unset($this->Staffing_Event_Reference);
        } else {
            $this->Staffing_Event_Reference = $staffing_Event_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Event_Reference',
            'Staffing_Event_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_RequestType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Event_Reference, Staffing_Event_Reference, Job_Application_Reference)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Event_Classification_Subcategory_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getEvent_Classification_Subcategory_Reference()
    {
        return $this->Event_Classification_Subcategory_Reference;
    }
    /**
     * Set Event_Classification_Subcategory_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $event_Classification_Subcategory_Reference
     * @return \StructType\Put_Undo_Move_from_Hire_RequestType
     */
    public function setEvent_Classification_Subcategory_Reference(\StructType\Event_Classification_SubcategoryObjectType $event_Classification_Subcategory_Reference = null)
    {
        $this->Event_Classification_Subcategory_Reference = $event_Classification_Subcategory_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Put_Undo_Move_from_Hire_RequestType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Undo_Move_from_Hire_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
