<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Site_Brand_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The web service is set to Add Only, but the Brand already exists. | Contains all the request data to add or update a brand.
 * @subpackage Structs
 */
class Put_Site_Brand_RequestType extends AbstractStructBase
{
    /**
     * The Brand_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of a brand.
     * - minOccurs: 0
     * @var \StructType\BrandObjectType
     */
    public $Brand_Reference;
    /**
     * The Brand_Data
     * Meta information extracted from the WSDL
     * - documentation: Element container for button, header, and additional component data for a brand.
     * @var \StructType\Brand_DataType
     */
    public $Brand_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Site_Brand_RequestType
     * @uses Put_Site_Brand_RequestType::setBrand_Reference()
     * @uses Put_Site_Brand_RequestType::setBrand_Data()
     * @uses Put_Site_Brand_RequestType::setAdd_Only()
     * @uses Put_Site_Brand_RequestType::setVersion()
     * @param \StructType\BrandObjectType $brand_Reference
     * @param \StructType\Brand_DataType $brand_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\BrandObjectType $brand_Reference = null, \StructType\Brand_DataType $brand_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setBrand_Reference($brand_Reference)
            ->setBrand_Data($brand_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Brand_Reference value
     * @return \StructType\BrandObjectType|null
     */
    public function getBrand_Reference()
    {
        return $this->Brand_Reference;
    }
    /**
     * Set Brand_Reference value
     * @param \StructType\BrandObjectType $brand_Reference
     * @return \StructType\Put_Site_Brand_RequestType
     */
    public function setBrand_Reference(\StructType\BrandObjectType $brand_Reference = null)
    {
        $this->Brand_Reference = $brand_Reference;
        return $this;
    }
    /**
     * Get Brand_Data value
     * @return \StructType\Brand_DataType|null
     */
    public function getBrand_Data()
    {
        return $this->Brand_Data;
    }
    /**
     * Set Brand_Data value
     * @param \StructType\Brand_DataType $brand_Data
     * @return \StructType\Put_Site_Brand_RequestType
     */
    public function setBrand_Data(\StructType\Brand_DataType $brand_Data = null)
    {
        $this->Brand_Data = $brand_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Site_Brand_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Site_Brand_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
