<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Recruiting_Agency_User_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the request data to add or update a Recruiting Agency User
 * @subpackage Structs
 */
class Put_Recruiting_Agency_User_RequestType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_User_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Recruiting Agency User.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_UserObjectType
     */
    public $Recruiting_Agency_User_Reference;
    /**
     * The Recruiting_Agency_User_Data
     * @var \StructType\Recruiting_Agency_User_DataType
     */
    public $Recruiting_Agency_User_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Recruiting_Agency_User_RequestType
     * @uses Put_Recruiting_Agency_User_RequestType::setRecruiting_Agency_User_Reference()
     * @uses Put_Recruiting_Agency_User_RequestType::setRecruiting_Agency_User_Data()
     * @uses Put_Recruiting_Agency_User_RequestType::setAdd_Only()
     * @uses Put_Recruiting_Agency_User_RequestType::setVersion()
     * @param \StructType\Recruiting_Agency_UserObjectType $recruiting_Agency_User_Reference
     * @param \StructType\Recruiting_Agency_User_DataType $recruiting_Agency_User_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Agency_UserObjectType $recruiting_Agency_User_Reference = null, \StructType\Recruiting_Agency_User_DataType $recruiting_Agency_User_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRecruiting_Agency_User_Reference($recruiting_Agency_User_Reference)
            ->setRecruiting_Agency_User_Data($recruiting_Agency_User_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Recruiting_Agency_User_Reference value
     * @return \StructType\Recruiting_Agency_UserObjectType|null
     */
    public function getRecruiting_Agency_User_Reference()
    {
        return $this->Recruiting_Agency_User_Reference;
    }
    /**
     * Set Recruiting_Agency_User_Reference value
     * @param \StructType\Recruiting_Agency_UserObjectType $recruiting_Agency_User_Reference
     * @return \StructType\Put_Recruiting_Agency_User_RequestType
     */
    public function setRecruiting_Agency_User_Reference(\StructType\Recruiting_Agency_UserObjectType $recruiting_Agency_User_Reference = null)
    {
        $this->Recruiting_Agency_User_Reference = $recruiting_Agency_User_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Agency_User_Data value
     * @return \StructType\Recruiting_Agency_User_DataType|null
     */
    public function getRecruiting_Agency_User_Data()
    {
        return $this->Recruiting_Agency_User_Data;
    }
    /**
     * Set Recruiting_Agency_User_Data value
     * @param \StructType\Recruiting_Agency_User_DataType $recruiting_Agency_User_Data
     * @return \StructType\Put_Recruiting_Agency_User_RequestType
     */
    public function setRecruiting_Agency_User_Data(\StructType\Recruiting_Agency_User_DataType $recruiting_Agency_User_Data = null)
    {
        $this->Recruiting_Agency_User_Data = $recruiting_Agency_User_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Recruiting_Agency_User_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Recruiting_Agency_User_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
