<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Primary_Posting_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains request information to make a Job Posting the Primary Posting
 * @subpackage Structs
 */
class Put_Primary_Posting_RequestType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Requisition Reference for the Job Posting to update.
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Posting to be updated.
     * @var \StructType\Job_PostingObjectType
     */
    public $Job_Posting_Reference;
    /**
     * The Forecasted_Payout
     * Meta information extracted from the WSDL
     * - documentation: The Forecasted Agency Payout on a Job Posting. Calculated at time of posting or updated later. The Currency for this value is stored separately on the Job Posting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Forecasted_Payout;
    /**
     * The Agency_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Currency for the Forecasted Agency Payout stored on the Job Posting.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Agency_Currency_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Primary_Posting_RequestType
     * @uses Put_Primary_Posting_RequestType::setJob_Requisition_Reference()
     * @uses Put_Primary_Posting_RequestType::setJob_Posting_Reference()
     * @uses Put_Primary_Posting_RequestType::setForecasted_Payout()
     * @uses Put_Primary_Posting_RequestType::setAgency_Currency_Reference()
     * @uses Put_Primary_Posting_RequestType::setVersion()
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @param float $forecasted_Payout
     * @param \StructType\CurrencyObjectType $agency_Currency_Reference
     * @param string $version
     */
    public function __construct(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, \StructType\Job_PostingObjectType $job_Posting_Reference = null, $forecasted_Payout = null, \StructType\CurrencyObjectType $agency_Currency_Reference = null, $version = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Posting_Reference($job_Posting_Reference)
            ->setForecasted_Payout($forecasted_Payout)
            ->setAgency_Currency_Reference($agency_Currency_Reference)
            ->setVersion($version);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Put_Primary_Posting_RequestType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType|null
     */
    public function getJob_Posting_Reference()
    {
        return $this->Job_Posting_Reference;
    }
    /**
     * Set Job_Posting_Reference value
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @return \StructType\Put_Primary_Posting_RequestType
     */
    public function setJob_Posting_Reference(\StructType\Job_PostingObjectType $job_Posting_Reference = null)
    {
        $this->Job_Posting_Reference = $job_Posting_Reference;
        return $this;
    }
    /**
     * Get Forecasted_Payout value
     * @return float|null
     */
    public function getForecasted_Payout()
    {
        return $this->Forecasted_Payout;
    }
    /**
     * Set Forecasted_Payout value
     * @param float $forecasted_Payout
     * @return \StructType\Put_Primary_Posting_RequestType
     */
    public function setForecasted_Payout($forecasted_Payout = null)
    {
        // validation for constraint: float
        if (!is_null($forecasted_Payout) && !(is_float($forecasted_Payout) || is_numeric($forecasted_Payout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecasted_Payout, true), gettype($forecasted_Payout)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($forecasted_Payout) && mb_strlen(mb_substr($forecasted_Payout, false !== mb_strpos($forecasted_Payout, '.') ? mb_strpos($forecasted_Payout, '.') + 1 : mb_strlen($forecasted_Payout))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($forecasted_Payout, true), mb_strlen(mb_substr($forecasted_Payout, mb_strpos($forecasted_Payout, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($forecasted_Payout) && $forecasted_Payout < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($forecasted_Payout, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($forecasted_Payout) && mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($forecasted_Payout, true), mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout))), __LINE__);
        }
        $this->Forecasted_Payout = $forecasted_Payout;
        return $this;
    }
    /**
     * Get Agency_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getAgency_Currency_Reference()
    {
        return $this->Agency_Currency_Reference;
    }
    /**
     * Set Agency_Currency_Reference value
     * @param \StructType\CurrencyObjectType $agency_Currency_Reference
     * @return \StructType\Put_Primary_Posting_RequestType
     */
    public function setAgency_Currency_Reference(\StructType\CurrencyObjectType $agency_Currency_Reference = null)
    {
        $this->Agency_Currency_Reference = $agency_Currency_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Primary_Posting_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
