<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Candidate_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the request data to add or update a candidate.
 * @subpackage Structs
 */
class Put_Candidate_RequestType extends AbstractStructBase
{
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Candidate.
     * - minOccurs: 0
     * @var \StructType\CandidateObjectType
     */
    public $Candidate_Reference;
    /**
     * The Candidate_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains name data, contact data, recruiting data, and status data.
     * @var \StructType\Candidate_DataType
     */
    public $Candidate_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Candidate_RequestType
     * @uses Put_Candidate_RequestType::setCandidate_Reference()
     * @uses Put_Candidate_RequestType::setCandidate_Data()
     * @uses Put_Candidate_RequestType::setAdd_Only()
     * @uses Put_Candidate_RequestType::setVersion()
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @param \StructType\Candidate_DataType $candidate_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\CandidateObjectType $candidate_Reference = null, \StructType\Candidate_DataType $candidate_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setCandidate_Reference($candidate_Reference)
            ->setCandidate_Data($candidate_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * Set Candidate_Reference value
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @return \StructType\Put_Candidate_RequestType
     */
    public function setCandidate_Reference(\StructType\CandidateObjectType $candidate_Reference = null)
    {
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Get Candidate_Data value
     * @return \StructType\Candidate_DataType|null
     */
    public function getCandidate_Data()
    {
        return $this->Candidate_Data;
    }
    /**
     * Set Candidate_Data value
     * @param \StructType\Candidate_DataType $candidate_Data
     * @return \StructType\Put_Candidate_RequestType
     */
    public function setCandidate_Data(\StructType\Candidate_DataType $candidate_Data = null)
    {
        $this->Candidate_Data = $candidate_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Candidate_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Candidate_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
