<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Applicant_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the Put Applicant Request Information.
 * @subpackage Structs
 */
class Put_Applicant_RequestType extends AbstractStructBase
{
    /**
     * The Applicant_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the Applicant being updated. For new Applicants, this element will not exist.
     * - minOccurs: 0
     * @var \StructType\ApplicantObjectType
     */
    public $Applicant_Reference;
    /**
     * The Applicant_Data
     * @var \StructType\Pre_Hire_Data_WWSType
     */
    public $Applicant_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Applicant_RequestType
     * @uses Put_Applicant_RequestType::setApplicant_Reference()
     * @uses Put_Applicant_RequestType::setApplicant_Data()
     * @uses Put_Applicant_RequestType::setAdd_Only()
     * @uses Put_Applicant_RequestType::setVersion()
     * @param \StructType\ApplicantObjectType $applicant_Reference
     * @param \StructType\Pre_Hire_Data_WWSType $applicant_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\ApplicantObjectType $applicant_Reference = null, \StructType\Pre_Hire_Data_WWSType $applicant_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setApplicant_Reference($applicant_Reference)
            ->setApplicant_Data($applicant_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Applicant_Reference value
     * @return \StructType\ApplicantObjectType|null
     */
    public function getApplicant_Reference()
    {
        return $this->Applicant_Reference;
    }
    /**
     * Set Applicant_Reference value
     * @param \StructType\ApplicantObjectType $applicant_Reference
     * @return \StructType\Put_Applicant_RequestType
     */
    public function setApplicant_Reference(\StructType\ApplicantObjectType $applicant_Reference = null)
    {
        $this->Applicant_Reference = $applicant_Reference;
        return $this;
    }
    /**
     * Get Applicant_Data value
     * @return \StructType\Pre_Hire_Data_WWSType|null
     */
    public function getApplicant_Data()
    {
        return $this->Applicant_Data;
    }
    /**
     * Set Applicant_Data value
     * @param \StructType\Pre_Hire_Data_WWSType $applicant_Data
     * @return \StructType\Put_Applicant_RequestType
     */
    public function setApplicant_Data(\StructType\Pre_Hire_Data_WWSType $applicant_Data = null)
    {
        $this->Applicant_Data = $applicant_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Applicant_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Applicant_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
