<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Calculated_Plan_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Calculated Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Calculated_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Calculated_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Calculated plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Calculated_Plan_InterfaceObjectType
     */
    public $Calculated_Plan_Reference;
    /**
     * The Amount_Override
     * Meta information extracted from the WSDL
     * - documentation: This field allows an override amount to be specified for workerswho are managed by compensation basis.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount_Override;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency of the calculated plan.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency of the calculated plan.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * Constructor method for Proposed_Calculated_Plan_Assignment_DataType
     * @uses Proposed_Calculated_Plan_Assignment_DataType::setCalculated_Plan_Reference()
     * @uses Proposed_Calculated_Plan_Assignment_DataType::setAmount_Override()
     * @uses Proposed_Calculated_Plan_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Calculated_Plan_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Calculated_Plan_Assignment_DataType::setActual_End_Date()
     * @param \StructType\Calculated_Plan_InterfaceObjectType $calculated_Plan_Reference
     * @param float $amount_Override
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param string $actual_End_Date
     */
    public function __construct(\StructType\Calculated_Plan_InterfaceObjectType $calculated_Plan_Reference = null, $amount_Override = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\FrequencyObjectType $frequency_Reference = null, $actual_End_Date = null)
    {
        $this
            ->setCalculated_Plan_Reference($calculated_Plan_Reference)
            ->setAmount_Override($amount_Override)
            ->setCurrency_Reference($currency_Reference)
            ->setFrequency_Reference($frequency_Reference)
            ->setActual_End_Date($actual_End_Date);
    }
    /**
     * Get Calculated_Plan_Reference value
     * @return \StructType\Calculated_Plan_InterfaceObjectType|null
     */
    public function getCalculated_Plan_Reference()
    {
        return $this->Calculated_Plan_Reference;
    }
    /**
     * Set Calculated_Plan_Reference value
     * @param \StructType\Calculated_Plan_InterfaceObjectType $calculated_Plan_Reference
     * @return \StructType\Proposed_Calculated_Plan_Assignment_DataType
     */
    public function setCalculated_Plan_Reference(\StructType\Calculated_Plan_InterfaceObjectType $calculated_Plan_Reference = null)
    {
        $this->Calculated_Plan_Reference = $calculated_Plan_Reference;
        return $this;
    }
    /**
     * Get Amount_Override value
     * @return float|null
     */
    public function getAmount_Override()
    {
        return $this->Amount_Override;
    }
    /**
     * Set Amount_Override value
     * @param float $amount_Override
     * @return \StructType\Proposed_Calculated_Plan_Assignment_DataType
     */
    public function setAmount_Override($amount_Override = null)
    {
        // validation for constraint: float
        if (!is_null($amount_Override) && !(is_float($amount_Override) || is_numeric($amount_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_Override, true), gettype($amount_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount_Override) && mb_strlen(mb_substr($amount_Override, false !== mb_strpos($amount_Override, '.') ? mb_strpos($amount_Override, '.') + 1 : mb_strlen($amount_Override))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount_Override, true), mb_strlen(mb_substr($amount_Override, mb_strpos($amount_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount_Override) && mb_strlen(preg_replace('/(\D)/', '', $amount_Override)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount_Override, true), mb_strlen(preg_replace('/(\D)/', '', $amount_Override))), __LINE__);
        }
        $this->Amount_Override = $amount_Override;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Calculated_Plan_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Calculated_Plan_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Calculated_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
}
