<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Allowance_Unit_Plan_Assignment_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Unit Allowance Plan Compensation data.
 * @subpackage Structs
 */
class Proposed_Allowance_Unit_Plan_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Unit_Allowance_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit Allowance Plan to update or assign. Does not default for Request Compensation Change.
     * - minOccurs: 0
     * @var \StructType\Allowance_Unit_PlanObjectType
     */
    public $Unit_Allowance_Plan_Reference;
    /**
     * The Number_of_Units
     * Meta information extracted from the WSDL
     * - documentation: Number of units to assign. Required if there is no default number of units for the plan.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Number_of_Units;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Frequency of the unit allowance plan. Required if there is no default frequency for the plan.
     * - minOccurs: 0
     * @var \StructType\FrequencyObjectType
     */
    public $Frequency_Reference;
    /**
     * The Per_Unit_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount per unit of the unit salary plan. Decimal precision of the amount must match the currency. Required if there is no default amount for the plan. | Amount per unit of the unit allowance plan. Required if there is no default
     * amount per unit for the plan.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Per_Unit_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency of the unit amount. Required if there is no default currency for the plan.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Reimbursement_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Reimbursement Start Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reimbursement_Start_Date;
    /**
     * The Actual_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Actual End Date for the plan assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Actual_End_Date;
    /**
     * The Fixed_for_Manage_by_Basis_Total
     * Meta information extracted from the WSDL
     * - documentation: This field allows a plan assignment for a remainder plan in the compensation basis algorithm to be considered a fixed plan assignment. This field is only valid for plans in the PCB of a worker that is managed by basis total where the
     * plan allows override. The flag will be ignored if the conditions are not met.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fixed_for_Manage_by_Basis_Total;
    /**
     * Constructor method for Proposed_Allowance_Unit_Plan_Assignment_DataType
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setUnit_Allowance_Plan_Reference()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setNumber_of_Units()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setFrequency_Reference()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setPer_Unit_Amount()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setCurrency_Reference()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setReimbursement_Start_Date()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setActual_End_Date()
     * @uses Proposed_Allowance_Unit_Plan_Assignment_DataType::setFixed_for_Manage_by_Basis_Total()
     * @param \StructType\Allowance_Unit_PlanObjectType $unit_Allowance_Plan_Reference
     * @param float $number_of_Units
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @param float $per_Unit_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $reimbursement_Start_Date
     * @param string $actual_End_Date
     * @param bool $fixed_for_Manage_by_Basis_Total
     */
    public function __construct(\StructType\Allowance_Unit_PlanObjectType $unit_Allowance_Plan_Reference = null, $number_of_Units = null, \StructType\FrequencyObjectType $frequency_Reference = null, $per_Unit_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $reimbursement_Start_Date = null, $actual_End_Date = null, $fixed_for_Manage_by_Basis_Total = null)
    {
        $this
            ->setUnit_Allowance_Plan_Reference($unit_Allowance_Plan_Reference)
            ->setNumber_of_Units($number_of_Units)
            ->setFrequency_Reference($frequency_Reference)
            ->setPer_Unit_Amount($per_Unit_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setReimbursement_Start_Date($reimbursement_Start_Date)
            ->setActual_End_Date($actual_End_Date)
            ->setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total);
    }
    /**
     * Get Unit_Allowance_Plan_Reference value
     * @return \StructType\Allowance_Unit_PlanObjectType|null
     */
    public function getUnit_Allowance_Plan_Reference()
    {
        return $this->Unit_Allowance_Plan_Reference;
    }
    /**
     * Set Unit_Allowance_Plan_Reference value
     * @param \StructType\Allowance_Unit_PlanObjectType $unit_Allowance_Plan_Reference
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setUnit_Allowance_Plan_Reference(\StructType\Allowance_Unit_PlanObjectType $unit_Allowance_Plan_Reference = null)
    {
        $this->Unit_Allowance_Plan_Reference = $unit_Allowance_Plan_Reference;
        return $this;
    }
    /**
     * Get Number_of_Units value
     * @return float|null
     */
    public function getNumber_of_Units()
    {
        return $this->Number_of_Units;
    }
    /**
     * Set Number_of_Units value
     * @param float $number_of_Units
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setNumber_of_Units($number_of_Units = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Units) && !(is_float($number_of_Units) || is_numeric($number_of_Units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Units, true), gettype($number_of_Units)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($number_of_Units) && mb_strlen(mb_substr($number_of_Units, false !== mb_strpos($number_of_Units, '.') ? mb_strpos($number_of_Units, '.') + 1 : mb_strlen($number_of_Units))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($number_of_Units, true), mb_strlen(mb_substr($number_of_Units, mb_strpos($number_of_Units, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Units) && $number_of_Units < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Units, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($number_of_Units) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Units)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($number_of_Units, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Units))), __LINE__);
        }
        $this->Number_of_Units = $number_of_Units;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\FrequencyObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\FrequencyObjectType $frequency_Reference
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setFrequency_Reference(\StructType\FrequencyObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Per_Unit_Amount value
     * @return float|null
     */
    public function getPer_Unit_Amount()
    {
        return $this->Per_Unit_Amount;
    }
    /**
     * Set Per_Unit_Amount value
     * @param float $per_Unit_Amount
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setPer_Unit_Amount($per_Unit_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($per_Unit_Amount) && !(is_float($per_Unit_Amount) || is_numeric($per_Unit_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($per_Unit_Amount, true), gettype($per_Unit_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($per_Unit_Amount) && mb_strlen(mb_substr($per_Unit_Amount, false !== mb_strpos($per_Unit_Amount, '.') ? mb_strpos($per_Unit_Amount, '.') + 1 : mb_strlen($per_Unit_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($per_Unit_Amount, true), mb_strlen(mb_substr($per_Unit_Amount, mb_strpos($per_Unit_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($per_Unit_Amount) && mb_strlen(preg_replace('/(\D)/', '', $per_Unit_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($per_Unit_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $per_Unit_Amount))), __LINE__);
        }
        $this->Per_Unit_Amount = $per_Unit_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Reimbursement_Start_Date value
     * @return string|null
     */
    public function getReimbursement_Start_Date()
    {
        return $this->Reimbursement_Start_Date;
    }
    /**
     * Set Reimbursement_Start_Date value
     * @param string $reimbursement_Start_Date
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setReimbursement_Start_Date($reimbursement_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($reimbursement_Start_Date) && !is_string($reimbursement_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reimbursement_Start_Date, true), gettype($reimbursement_Start_Date)), __LINE__);
        }
        $this->Reimbursement_Start_Date = $reimbursement_Start_Date;
        return $this;
    }
    /**
     * Get Actual_End_Date value
     * @return string|null
     */
    public function getActual_End_Date()
    {
        return $this->Actual_End_Date;
    }
    /**
     * Set Actual_End_Date value
     * @param string $actual_End_Date
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setActual_End_Date($actual_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($actual_End_Date) && !is_string($actual_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actual_End_Date, true), gettype($actual_End_Date)), __LINE__);
        }
        $this->Actual_End_Date = $actual_End_Date;
        return $this;
    }
    /**
     * Get Fixed_for_Manage_by_Basis_Total value
     * @return bool|null
     */
    public function getFixed_for_Manage_by_Basis_Total()
    {
        return $this->Fixed_for_Manage_by_Basis_Total;
    }
    /**
     * Set Fixed_for_Manage_by_Basis_Total value
     * @param bool $fixed_for_Manage_by_Basis_Total
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_DataType
     */
    public function setFixed_for_Manage_by_Basis_Total($fixed_for_Manage_by_Basis_Total = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixed_for_Manage_by_Basis_Total) && !is_bool($fixed_for_Manage_by_Basis_Total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixed_for_Manage_by_Basis_Total, true), gettype($fixed_for_Manage_by_Basis_Total)), __LINE__);
        }
        $this->Fixed_for_Manage_by_Basis_Total = $fixed_for_Manage_by_Basis_Total;
        return $this;
    }
}
