<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pre-Hire_Resume_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The resume for an applicant.
 * @subpackage Structs
 */
class Pre_Hire_Resume_Detail_DataType extends AbstractStructBase
{
    /**
     * The Resume_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a specific resume for an applicant.
     * - minOccurs: 0
     * @var \StructType\Applicant_ResumeObjectType
     */
    public $Resume_Reference;
    /**
     * The Resume_Data
     * Meta information extracted from the WSDL
     * - documentation: The details of a resume (resume, name, comments).
     * - minOccurs: 0
     * @var \StructType\Attachment_Data_WWSType
     */
    public $Resume_Data;
    /**
     * Constructor method for Pre-Hire_Resume_Detail_DataType
     * @uses Pre_Hire_Resume_Detail_DataType::setResume_Reference()
     * @uses Pre_Hire_Resume_Detail_DataType::setResume_Data()
     * @param \StructType\Applicant_ResumeObjectType $resume_Reference
     * @param \StructType\Attachment_Data_WWSType $resume_Data
     */
    public function __construct(\StructType\Applicant_ResumeObjectType $resume_Reference = null, \StructType\Attachment_Data_WWSType $resume_Data = null)
    {
        $this
            ->setResume_Reference($resume_Reference)
            ->setResume_Data($resume_Data);
    }
    /**
     * Get Resume_Reference value
     * @return \StructType\Applicant_ResumeObjectType|null
     */
    public function getResume_Reference()
    {
        return $this->Resume_Reference;
    }
    /**
     * Set Resume_Reference value
     * @param \StructType\Applicant_ResumeObjectType $resume_Reference
     * @return \StructType\Pre_Hire_Resume_Detail_DataType
     */
    public function setResume_Reference(\StructType\Applicant_ResumeObjectType $resume_Reference = null)
    {
        $this->Resume_Reference = $resume_Reference;
        return $this;
    }
    /**
     * Get Resume_Data value
     * @return \StructType\Attachment_Data_WWSType|null
     */
    public function getResume_Data()
    {
        return $this->Resume_Data;
    }
    /**
     * Set Resume_Data value
     * @param \StructType\Attachment_Data_WWSType $resume_Data
     * @return \StructType\Pre_Hire_Resume_Detail_DataType
     */
    public function setResume_Data(\StructType\Attachment_Data_WWSType $resume_Data = null)
    {
        $this->Resume_Data = $resume_Data;
        return $this;
    }
}
