<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Post_Job_Sub_Business_ProcessType StructType
 * Meta information extracted from the WSDL
 * - documentation: Run the Post Job Sub Business Process to post this job requisition to one or more Job Posting Sites. To use, Post Job must be enabled in the Workflow Definition for Create Job Requisition.
 * @subpackage Structs
 */
class Post_Job_Sub_Business_ProcessType extends AbstractStructBase
{
    /**
     * The Business_Sub_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Sub_Process_ParametersType
     */
    public $Business_Sub_Process_Parameters;
    /**
     * The Post_Job_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper for the data for each Job Posting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Posting_Site_DataType[]
     */
    public $Post_Job_Data;
    /**
     * Constructor method for Post_Job_Sub_Business_ProcessType
     * @uses Post_Job_Sub_Business_ProcessType::setBusiness_Sub_Process_Parameters()
     * @uses Post_Job_Sub_Business_ProcessType::setPost_Job_Data()
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @param \StructType\Job_Posting_Site_DataType[] $post_Job_Data
     */
    public function __construct(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null, array $post_Job_Data = array())
    {
        $this
            ->setBusiness_Sub_Process_Parameters($business_Sub_Process_Parameters)
            ->setPost_Job_Data($post_Job_Data);
    }
    /**
     * Get Business_Sub_Process_Parameters value
     * @return \StructType\Business_Sub_Process_ParametersType|null
     */
    public function getBusiness_Sub_Process_Parameters()
    {
        return $this->Business_Sub_Process_Parameters;
    }
    /**
     * Set Business_Sub_Process_Parameters value
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @return \StructType\Post_Job_Sub_Business_ProcessType
     */
    public function setBusiness_Sub_Process_Parameters(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null)
    {
        $this->Business_Sub_Process_Parameters = $business_Sub_Process_Parameters;
        return $this;
    }
    /**
     * Get Post_Job_Data value
     * @return \StructType\Job_Posting_Site_DataType[]|null
     */
    public function getPost_Job_Data()
    {
        return $this->Post_Job_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPost_Job_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPost_Job_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePost_Job_DataForArrayConstraintsFromSetPost_Job_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $post_Job_Sub_Business_ProcessTypePost_Job_DataItem) {
            // validation for constraint: itemType
            if (!$post_Job_Sub_Business_ProcessTypePost_Job_DataItem instanceof \StructType\Job_Posting_Site_DataType) {
                $invalidValues[] = is_object($post_Job_Sub_Business_ProcessTypePost_Job_DataItem) ? get_class($post_Job_Sub_Business_ProcessTypePost_Job_DataItem) : sprintf('%s(%s)', gettype($post_Job_Sub_Business_ProcessTypePost_Job_DataItem), var_export($post_Job_Sub_Business_ProcessTypePost_Job_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Post_Job_Data property can only contain items of type \StructType\Job_Posting_Site_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Post_Job_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Site_DataType[] $post_Job_Data
     * @return \StructType\Post_Job_Sub_Business_ProcessType
     */
    public function setPost_Job_Data(array $post_Job_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($post_Job_DataArrayErrorMessage = self::validatePost_Job_DataForArrayConstraintsFromSetPost_Job_Data($post_Job_Data))) {
            throw new \InvalidArgumentException($post_Job_DataArrayErrorMessage, __LINE__);
        }
        $this->Post_Job_Data = $post_Job_Data;
        return $this;
    }
    /**
     * Add item to Post_Job_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Site_DataType $item
     * @return \StructType\Post_Job_Sub_Business_ProcessType
     */
    public function addToPost_Job_Data(\StructType\Job_Posting_Site_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_Site_DataType) {
            throw new \InvalidArgumentException(sprintf('The Post_Job_Data property can only contain items of type \StructType\Job_Posting_Site_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Post_Job_Data[] = $item;
        return $this;
    }
}
