<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Post_Job_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Responds with the Event ID for the Job Posting Event.
 * @subpackage Structs
 */
class Post_Job_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Event Reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Job_Posting_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Posting_DataType[]
     */
    public $Job_Posting_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Post_Job_ResponseType
     * @uses Post_Job_ResponseType::setEvent_Reference()
     * @uses Post_Job_ResponseType::setJob_Posting_Data()
     * @uses Post_Job_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Job_Posting_DataType[] $job_Posting_Data
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, array $job_Posting_Data = array(), $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setJob_Posting_Data($job_Posting_Data)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Post_Job_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Data value
     * @return \StructType\Job_Posting_DataType[]|null
     */
    public function getJob_Posting_Data()
    {
        return $this->Job_Posting_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_DataForArrayConstraintsFromSetJob_Posting_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $post_Job_ResponseTypeJob_Posting_DataItem) {
            // validation for constraint: itemType
            if (!$post_Job_ResponseTypeJob_Posting_DataItem instanceof \StructType\Job_Posting_DataType) {
                $invalidValues[] = is_object($post_Job_ResponseTypeJob_Posting_DataItem) ? get_class($post_Job_ResponseTypeJob_Posting_DataItem) : sprintf('%s(%s)', gettype($post_Job_ResponseTypeJob_Posting_DataItem), var_export($post_Job_ResponseTypeJob_Posting_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Data property can only contain items of type \StructType\Job_Posting_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_DataType[] $job_Posting_Data
     * @return \StructType\Post_Job_ResponseType
     */
    public function setJob_Posting_Data(array $job_Posting_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_DataArrayErrorMessage = self::validateJob_Posting_DataForArrayConstraintsFromSetJob_Posting_Data($job_Posting_Data))) {
            throw new \InvalidArgumentException($job_Posting_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Data = $job_Posting_Data;
        return $this;
    }
    /**
     * Add item to Job_Posting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_DataType $item
     * @return \StructType\Post_Job_ResponseType
     */
    public function addToJob_Posting_Data(\StructType\Job_Posting_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Data property can only contain items of type \StructType\Job_Posting_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Post_Job_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
