<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offer_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains offer details
 * @subpackage Structs
 */
class Offer_Event_DataType extends AbstractStructBase
{
    /**
     * The Hire_Date
     * Meta information extracted from the WSDL
     * - documentation: The hire date associated with the offer
     * @var string
     */
    public $Hire_Date;
    /**
     * The Hire_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: The hire reason associated with the offer
     * - minOccurs: 0
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Hire_Reason_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location associated with the offer
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Proposed_End_Date
     * Meta information extracted from the WSDL
     * - documentation: The proposed end date associated with the offer
     * - minOccurs: 0
     * @var string
     */
    public $Proposed_End_Date;
    /**
     * The Document_Language_Reference
     * Meta information extracted from the WSDL
     * - documentation: The document language associated with the offer
     * - minOccurs: 0
     * @var \StructType\User_LanguageObjectType
     */
    public $Document_Language_Reference;
    /**
     * The Job_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: The job profile associated with the offer
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Business_Title
     * Meta information extracted from the WSDL
     * - documentation: The business title associated with the offer
     * @var string
     */
    public $Business_Title;
    /**
     * The Default_Weekly_Hours
     * Meta information extracted from the WSDL
     * - documentation: The default weekly hours associated with the offer
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Default_Weekly_Hours;
    /**
     * The Scheduled_Weekly_Hours
     * Meta information extracted from the WSDL
     * - documentation: The Schedule Hours for the Job Requisition. | The scheduled weekly hours for the job requisition. If empty, Workday automatically populates this value from the position restrictions. | The scheduled weekly hours associated with the
     * offer
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Scheduled_Weekly_Hours;
    /**
     * The Specify_Paid_FTE
     * Meta information extracted from the WSDL
     * - documentation: True if Paid FTE Percentage is specified.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Specify_Paid_FTE;
    /**
     * The Paid_FTE
     * Meta information extracted from the WSDL
     * - documentation: The paid full time equivalent percentage for the position, entered as a decimal value. This overrides the calculated full time equivalent.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Paid_FTE;
    /**
     * The Specify_Working_FTE
     * Meta information extracted from the WSDL
     * - documentation: True if Working FTE Percentage is specified.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Specify_Working_FTE;
    /**
     * The Working_FTE
     * Meta information extracted from the WSDL
     * - documentation: The working full time equivalent percentage for the position, entered as a decimal value. This overrides the calculated full time equivalent.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Working_FTE;
    /**
     * Constructor method for Offer_Event_DataType
     * @uses Offer_Event_DataType::setHire_Date()
     * @uses Offer_Event_DataType::setHire_Reason_Reference()
     * @uses Offer_Event_DataType::setLocation_Reference()
     * @uses Offer_Event_DataType::setProposed_End_Date()
     * @uses Offer_Event_DataType::setDocument_Language_Reference()
     * @uses Offer_Event_DataType::setJob_Profile_Reference()
     * @uses Offer_Event_DataType::setBusiness_Title()
     * @uses Offer_Event_DataType::setDefault_Weekly_Hours()
     * @uses Offer_Event_DataType::setScheduled_Weekly_Hours()
     * @uses Offer_Event_DataType::setSpecify_Paid_FTE()
     * @uses Offer_Event_DataType::setPaid_FTE()
     * @uses Offer_Event_DataType::setSpecify_Working_FTE()
     * @uses Offer_Event_DataType::setWorking_FTE()
     * @param string $hire_Date
     * @param \StructType\Event_Classification_SubcategoryObjectType $hire_Reason_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param string $proposed_End_Date
     * @param \StructType\User_LanguageObjectType $document_Language_Reference
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param string $business_Title
     * @param float $default_Weekly_Hours
     * @param float $scheduled_Weekly_Hours
     * @param bool $specify_Paid_FTE
     * @param float $paid_FTE
     * @param bool $specify_Working_FTE
     * @param float $working_FTE
     */
    public function __construct($hire_Date = null, \StructType\Event_Classification_SubcategoryObjectType $hire_Reason_Reference = null, \StructType\LocationObjectType $location_Reference = null, $proposed_End_Date = null, \StructType\User_LanguageObjectType $document_Language_Reference = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, $business_Title = null, $default_Weekly_Hours = null, $scheduled_Weekly_Hours = null, $specify_Paid_FTE = null, $paid_FTE = null, $specify_Working_FTE = null, $working_FTE = null)
    {
        $this
            ->setHire_Date($hire_Date)
            ->setHire_Reason_Reference($hire_Reason_Reference)
            ->setLocation_Reference($location_Reference)
            ->setProposed_End_Date($proposed_End_Date)
            ->setDocument_Language_Reference($document_Language_Reference)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setBusiness_Title($business_Title)
            ->setDefault_Weekly_Hours($default_Weekly_Hours)
            ->setScheduled_Weekly_Hours($scheduled_Weekly_Hours)
            ->setSpecify_Paid_FTE($specify_Paid_FTE)
            ->setPaid_FTE($paid_FTE)
            ->setSpecify_Working_FTE($specify_Working_FTE)
            ->setWorking_FTE($working_FTE);
    }
    /**
     * Get Hire_Date value
     * @return string|null
     */
    public function getHire_Date()
    {
        return $this->Hire_Date;
    }
    /**
     * Set Hire_Date value
     * @param string $hire_Date
     * @return \StructType\Offer_Event_DataType
     */
    public function setHire_Date($hire_Date = null)
    {
        // validation for constraint: string
        if (!is_null($hire_Date) && !is_string($hire_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hire_Date, true), gettype($hire_Date)), __LINE__);
        }
        $this->Hire_Date = $hire_Date;
        return $this;
    }
    /**
     * Get Hire_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getHire_Reason_Reference()
    {
        return $this->Hire_Reason_Reference;
    }
    /**
     * Set Hire_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $hire_Reason_Reference
     * @return \StructType\Offer_Event_DataType
     */
    public function setHire_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $hire_Reason_Reference = null)
    {
        $this->Hire_Reason_Reference = $hire_Reason_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Offer_Event_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Proposed_End_Date value
     * @return string|null
     */
    public function getProposed_End_Date()
    {
        return $this->Proposed_End_Date;
    }
    /**
     * Set Proposed_End_Date value
     * @param string $proposed_End_Date
     * @return \StructType\Offer_Event_DataType
     */
    public function setProposed_End_Date($proposed_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($proposed_End_Date) && !is_string($proposed_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposed_End_Date, true), gettype($proposed_End_Date)), __LINE__);
        }
        $this->Proposed_End_Date = $proposed_End_Date;
        return $this;
    }
    /**
     * Get Document_Language_Reference value
     * @return \StructType\User_LanguageObjectType|null
     */
    public function getDocument_Language_Reference()
    {
        return $this->Document_Language_Reference;
    }
    /**
     * Set Document_Language_Reference value
     * @param \StructType\User_LanguageObjectType $document_Language_Reference
     * @return \StructType\Offer_Event_DataType
     */
    public function setDocument_Language_Reference(\StructType\User_LanguageObjectType $document_Language_Reference = null)
    {
        $this->Document_Language_Reference = $document_Language_Reference;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Offer_Event_DataType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Business_Title value
     * @return string|null
     */
    public function getBusiness_Title()
    {
        return $this->Business_Title;
    }
    /**
     * Set Business_Title value
     * @param string $business_Title
     * @return \StructType\Offer_Event_DataType
     */
    public function setBusiness_Title($business_Title = null)
    {
        // validation for constraint: string
        if (!is_null($business_Title) && !is_string($business_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Title, true), gettype($business_Title)), __LINE__);
        }
        $this->Business_Title = $business_Title;
        return $this;
    }
    /**
     * Get Default_Weekly_Hours value
     * @return float|null
     */
    public function getDefault_Weekly_Hours()
    {
        return $this->Default_Weekly_Hours;
    }
    /**
     * Set Default_Weekly_Hours value
     * @param float $default_Weekly_Hours
     * @return \StructType\Offer_Event_DataType
     */
    public function setDefault_Weekly_Hours($default_Weekly_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($default_Weekly_Hours) && !(is_float($default_Weekly_Hours) || is_numeric($default_Weekly_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Weekly_Hours, true), gettype($default_Weekly_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($default_Weekly_Hours) && mb_strlen(mb_substr($default_Weekly_Hours, false !== mb_strpos($default_Weekly_Hours, '.') ? mb_strpos($default_Weekly_Hours, '.') + 1 : mb_strlen($default_Weekly_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($default_Weekly_Hours, true), mb_strlen(mb_substr($default_Weekly_Hours, mb_strpos($default_Weekly_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($default_Weekly_Hours) && $default_Weekly_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($default_Weekly_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($default_Weekly_Hours) && mb_strlen(preg_replace('/(\D)/', '', $default_Weekly_Hours)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($default_Weekly_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $default_Weekly_Hours))), __LINE__);
        }
        $this->Default_Weekly_Hours = $default_Weekly_Hours;
        return $this;
    }
    /**
     * Get Scheduled_Weekly_Hours value
     * @return float|null
     */
    public function getScheduled_Weekly_Hours()
    {
        return $this->Scheduled_Weekly_Hours;
    }
    /**
     * Set Scheduled_Weekly_Hours value
     * @param float $scheduled_Weekly_Hours
     * @return \StructType\Offer_Event_DataType
     */
    public function setScheduled_Weekly_Hours($scheduled_Weekly_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($scheduled_Weekly_Hours) && !(is_float($scheduled_Weekly_Hours) || is_numeric($scheduled_Weekly_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduled_Weekly_Hours, true), gettype($scheduled_Weekly_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($scheduled_Weekly_Hours) && mb_strlen(mb_substr($scheduled_Weekly_Hours, false !== mb_strpos($scheduled_Weekly_Hours, '.') ? mb_strpos($scheduled_Weekly_Hours, '.') + 1 : mb_strlen($scheduled_Weekly_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($scheduled_Weekly_Hours, true), mb_strlen(mb_substr($scheduled_Weekly_Hours, mb_strpos($scheduled_Weekly_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($scheduled_Weekly_Hours) && $scheduled_Weekly_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($scheduled_Weekly_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($scheduled_Weekly_Hours) && mb_strlen(preg_replace('/(\D)/', '', $scheduled_Weekly_Hours)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($scheduled_Weekly_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $scheduled_Weekly_Hours))), __LINE__);
        }
        $this->Scheduled_Weekly_Hours = $scheduled_Weekly_Hours;
        return $this;
    }
    /**
     * Get Specify_Paid_FTE value
     * @return bool|null
     */
    public function getSpecify_Paid_FTE()
    {
        return $this->Specify_Paid_FTE;
    }
    /**
     * Set Specify_Paid_FTE value
     * @param bool $specify_Paid_FTE
     * @return \StructType\Offer_Event_DataType
     */
    public function setSpecify_Paid_FTE($specify_Paid_FTE = null)
    {
        // validation for constraint: boolean
        if (!is_null($specify_Paid_FTE) && !is_bool($specify_Paid_FTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specify_Paid_FTE, true), gettype($specify_Paid_FTE)), __LINE__);
        }
        $this->Specify_Paid_FTE = $specify_Paid_FTE;
        return $this;
    }
    /**
     * Get Paid_FTE value
     * @return float|null
     */
    public function getPaid_FTE()
    {
        return $this->Paid_FTE;
    }
    /**
     * Set Paid_FTE value
     * @param float $paid_FTE
     * @return \StructType\Offer_Event_DataType
     */
    public function setPaid_FTE($paid_FTE = null)
    {
        // validation for constraint: float
        if (!is_null($paid_FTE) && !(is_float($paid_FTE) || is_numeric($paid_FTE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paid_FTE, true), gettype($paid_FTE)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($paid_FTE) && mb_strlen(mb_substr($paid_FTE, false !== mb_strpos($paid_FTE, '.') ? mb_strpos($paid_FTE, '.') + 1 : mb_strlen($paid_FTE))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($paid_FTE, true), mb_strlen(mb_substr($paid_FTE, mb_strpos($paid_FTE, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($paid_FTE) && $paid_FTE < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($paid_FTE, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($paid_FTE) && mb_strlen(preg_replace('/(\D)/', '', $paid_FTE)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($paid_FTE, true), mb_strlen(preg_replace('/(\D)/', '', $paid_FTE))), __LINE__);
        }
        $this->Paid_FTE = $paid_FTE;
        return $this;
    }
    /**
     * Get Specify_Working_FTE value
     * @return bool|null
     */
    public function getSpecify_Working_FTE()
    {
        return $this->Specify_Working_FTE;
    }
    /**
     * Set Specify_Working_FTE value
     * @param bool $specify_Working_FTE
     * @return \StructType\Offer_Event_DataType
     */
    public function setSpecify_Working_FTE($specify_Working_FTE = null)
    {
        // validation for constraint: boolean
        if (!is_null($specify_Working_FTE) && !is_bool($specify_Working_FTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specify_Working_FTE, true), gettype($specify_Working_FTE)), __LINE__);
        }
        $this->Specify_Working_FTE = $specify_Working_FTE;
        return $this;
    }
    /**
     * Get Working_FTE value
     * @return float|null
     */
    public function getWorking_FTE()
    {
        return $this->Working_FTE;
    }
    /**
     * Set Working_FTE value
     * @param float $working_FTE
     * @return \StructType\Offer_Event_DataType
     */
    public function setWorking_FTE($working_FTE = null)
    {
        // validation for constraint: float
        if (!is_null($working_FTE) && !(is_float($working_FTE) || is_numeric($working_FTE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($working_FTE, true), gettype($working_FTE)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($working_FTE) && mb_strlen(mb_substr($working_FTE, false !== mb_strpos($working_FTE, '.') ? mb_strpos($working_FTE, '.') + 1 : mb_strlen($working_FTE))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($working_FTE, true), mb_strlen(mb_substr($working_FTE, mb_strpos($working_FTE, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($working_FTE) && $working_FTE < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($working_FTE, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($working_FTE) && mb_strlen(preg_replace('/(\D)/', '', $working_FTE)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($working_FTE, true), mb_strlen(preg_replace('/(\D)/', '', $working_FTE))), __LINE__);
        }
        $this->Working_FTE = $working_FTE;
        return $this;
    }
}
